package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author jingran
 * @version 1.0
 * @Date 2022/4/19 3:55 下午
 */
@ApiModel(value = "CsWmsReceiveBasicsReqDto", description = "wms发货回传传入DTO")
public class CsWmsReceiveBasicsReqDto implements Serializable {

    /**
     * wms订单号
     **/
    @ApiModelProperty(name = "wmsOrderNo", value = "wms订单号")
    private String wmsOrderNo;

    /**
     * 平台单号(来源于第三方系统)
     **/
    @ApiModelProperty(name = "platformOrderNo", value = "平台单号(来源于第三方系统)")
    private String platformOrderNo;

    /**
     * 入库通知单号
     **/
    @ApiModelProperty(name = "inNoticeOrderNo", value = "出库通知单号")
    private String inNoticeOrderNo;

    /**
     * 入库时间
     **/
    @ApiModelProperty(name = "inTime", value = "入库时间")
    private Date inTime;

    /**
     * 物流公司编码
     **/
    @ApiModelProperty(name = "shippingCompanyCode", value = "物流公司编码")
    private String shippingCompanyCode;

    /**
     * 物流公司名称
     **/
    @ApiModelProperty(name = "shippingCompanyName", value = "物流公司名称")
    private String shippingCompanyName;

    /**
     * 物流单号
     **/
    @ApiModelProperty(name = "shippingNo", value = "物流单号")
    private String shippingNo;

    /**
     * 商品明细信息
     **/
    @ApiModelProperty(name = "detailReqDtoList", value = "商品明细信息")
    private List<CsWmsBasicsDetailReqDto> detailReqDtoList;

    public CsWmsReceiveBasicsReqDto() {
    }

    public String getPlatformOrderNo() {
        return platformOrderNo;
    }

    public void setPlatformOrderNo(String platformOrderNo) {
        this.platformOrderNo = platformOrderNo;
    }

    public String getShippingCompanyCode() {
        return shippingCompanyCode;
    }

    public void setShippingCompanyCode(String shippingCompanyCode) {
        this.shippingCompanyCode = shippingCompanyCode;
    }

    public String getShippingCompanyName() {
        return shippingCompanyName;
    }

    public void setShippingCompanyName(String shippingCompanyName) {
        this.shippingCompanyName = shippingCompanyName;
    }

    public String getShippingNo() {
        return shippingNo;
    }

    public void setShippingNo(String shippingNo) {
        this.shippingNo = shippingNo;
    }

    public List<CsWmsBasicsDetailReqDto> getDetailReqDtoList() {
        return detailReqDtoList;
    }

    public void setDetailReqDtoList(List<CsWmsBasicsDetailReqDto> detailReqDtoList) {
        this.detailReqDtoList = detailReqDtoList;
    }

    public String getInNoticeOrderNo() {
        return inNoticeOrderNo;
    }

    public void setInNoticeOrderNo(String inNoticeOrderNo) {
        this.inNoticeOrderNo = inNoticeOrderNo;
    }

    public Date getInTime() {
        return inTime;
    }

    public void setInTime(Date inTime) {
        this.inTime = inTime;
    }

    public String getWmsOrderNo() {
        return wmsOrderNo;
    }

    public void setWmsOrderNo(String wmsOrderNo) {
        this.wmsOrderNo = wmsOrderNo;
    }
}
