package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 发送给WMS的基础DTO
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/4/19 3:55 下午
 */
@ApiModel(value = "CsWmsSendBasicsReqDto", description = "发送给WMS的基础DTO")
public class CsWmsSendBasicsReqDto implements Serializable {

    /**
     * 平台单号(来源于第三方系统)
     **/
    @ApiModelProperty(name = "platformOrderNo", value = "平台单号(来源于第三方系统)")
    private String platformOrderNo;

    /**
     * 入库通知单号
     **/
    @ApiModelProperty(name = "inNoticeOrderNo", value = "出库通知单号")
    private String inNoticeOrderNo;

    /**
     * 逻辑仓仓库编码
     **/
    @ApiModelProperty(name = "logicWarehouseCode", value = "逻辑仓仓库编码")
    private String logicWarehouseCode;

    /**
     * 物理仓仓库编码
     **/
    @ApiModelProperty(name = "physicsWarehouseCode", value = "物理仓仓库编码")
    private String physicsWarehouseCode;

    /**
     * 物流单号
     **/
    @ApiModelProperty(name = "shippingNo", value = "物流单号")
    private String shippingNo;

    /**
     * 商品明细信息
     **/
    @ApiModelProperty(name = "detailReqDtoList", value = "商品明细信息")
    private List<CsWmsBasicsDetailReqDto> detailReqDtoList;

    public CsWmsSendBasicsReqDto() {
    }

    public String getPlatformOrderNo() {
        return platformOrderNo;
    }

    public void setPlatformOrderNo(String platformOrderNo) {
        this.platformOrderNo = platformOrderNo;
    }

    public String getInNoticeOrderNo() {
        return inNoticeOrderNo;
    }

    public void setInNoticeOrderNo(String inNoticeOrderNo) {
        this.inNoticeOrderNo = inNoticeOrderNo;
    }

    public String getLogicWarehouseCode() {
        return logicWarehouseCode;
    }

    public void setLogicWarehouseCode(String logicWarehouseCode) {
        this.logicWarehouseCode = logicWarehouseCode;
    }

    public String getPhysicsWarehouseCode() {
        return physicsWarehouseCode;
    }

    public void setPhysicsWarehouseCode(String physicsWarehouseCode) {
        this.physicsWarehouseCode = physicsWarehouseCode;
    }

    public String getShippingNo() {
        return shippingNo;
    }

    public void setShippingNo(String shippingNo) {
        this.shippingNo = shippingNo;
    }

    public List<CsWmsBasicsDetailReqDto> getDetailReqDtoList() {
        return detailReqDtoList;
    }

    public void setDetailReqDtoList(List<CsWmsBasicsDetailReqDto> detailReqDtoList) {
        this.detailReqDtoList = detailReqDtoList;
    }
}
