/**
 * @(#)CsLogicInventoryRespDto.java 1.0 2021/12/29 11:11
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @author jingran
 * @Description CsLogicInventoryRespDto
 * @Date: 2021/12/29 11:11
 * @since 1.0.0
 */
@ApiModel(value = "CsInventoryBatchQueryRespDto", description = "返回信息Dto")
public class CsInventoryBatchQueryReqDto implements Serializable {

    /**
     * 查询库存策略选择   com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum
     *
     * 默认：逻辑仓logic
     */
    @ApiModelProperty(name = "inventoryStrategy", value = "查询库存策略选择,com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum")
    private String inventoryStrategy;

    /**
     * 批次右匹配模糊查询
     **/
    @ApiModelProperty(name = "batchLike", value = "批次右匹配模糊查询")
    private String batchLike;

    /**
     * 长编码
     **/
    @ApiModelProperty(name = "longCode", value = "长编码")
    private String longCode;

    private String warehouseCode;

    @ApiModelProperty(name = "isGtZero", value = "是否过滤可用大于0的库存")
    private Boolean isGtZero=false;

    public Boolean getGtZero() {
        return isGtZero;
    }

    public void setGtZero(Boolean gtZero) {
        isGtZero = gtZero;
    }

    public CsInventoryBatchQueryReqDto() {
    }

    public String getInventoryStrategy() {
        return inventoryStrategy;
    }

    public void setInventoryStrategy(String inventoryStrategy) {
        this.inventoryStrategy = inventoryStrategy;
    }

    public String getBatchLike() {
        return batchLike;
    }

    public void setBatchLike(String batchLike) {
        this.batchLike = batchLike;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }
}
