package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryBalanceRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsPhysicsInventoryBalanceRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 库存盘点单导入返回dto
 *
 * @author 宁毅
 * @since 2022-04-25
 */
@ApiModel(value = "CsInventoryImportResultDto", description = "库存盘点单导入返回dto")
public class CsInventoryImportResultDto implements Serializable {
    @ApiModelProperty(name = "successNum", value = "导入成功数量")
    private Integer successNum = 0;

    @ApiModelProperty(name = "errorNum", value = "导入失败数量")
    private Integer errorNum = 0;

    @ApiModelProperty(name = "url", value = "导入错误信息地址")
    private String url;

    @ApiModelProperty(name = "logicInventoryBalanceRespDtoList", value = "逻辑仓库导入成功的商品库存信息")
    private List<CsLogicInventoryBalanceRespDto> logicInventoryBalanceRespDtoList;

    @ApiModelProperty(name = "physicsInventoryBalanceRespDtoList", value = "物理仓库导入成功的商品库存信息")
    private List<CsPhysicsInventoryBalanceRespDto> physicsInventoryBalanceRespDtoList;

    public Integer getSuccessNum() {
        return successNum;
    }

    public void setSuccessNum(Integer successNum) {
        this.successNum = successNum;
    }

    public Integer getErrorNum() {
        return errorNum;
    }

    public void setErrorNum(Integer errorNum) {
        this.errorNum = errorNum;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<CsLogicInventoryBalanceRespDto> getLogicInventoryBalanceRespDtoList() {
        return logicInventoryBalanceRespDtoList;
    }

    public List<CsPhysicsInventoryBalanceRespDto> getPhysicsInventoryBalanceRespDtoList() {
        return physicsInventoryBalanceRespDtoList;
    }

    public void setLogicInventoryBalanceRespDtoList(List<CsLogicInventoryBalanceRespDto> logicInventoryBalanceRespDtoList) {
        this.logicInventoryBalanceRespDtoList = logicInventoryBalanceRespDtoList;
    }

    public void setPhysicsInventoryBalanceRespDtoList(List<CsPhysicsInventoryBalanceRespDto> physicsInventoryBalanceRespDtoList) {
        this.physicsInventoryBalanceRespDtoList = physicsInventoryBalanceRespDtoList;
    }
}
