package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryCoverInventoryFlagEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 库存操作货品明细请求DTO
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/18 2:21 下午
 */
@ApiModel(value = "CsInventoryOperateCargoReqDto", description = "库存预占货品明细请求DTO")
public class CsInventoryOperateCargoReqDto implements Serializable {

    @ApiModelProperty(name = "id", value = "主键")
    private Long id;

    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;

    /**
     * 货品编码
     */
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    /**
     * 商品长编码
     */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;

    /**
     * 货品批次，对于C端的下单，是没有批次的，但是其他类型的库存操作，可能存在批次，存在批次必传
     */
    @ApiModelProperty(name = "batch", value = "货品批次，对于C端的下单，是没有批次的，但是其他类型的库存操作，可能存在批次，存在批次必传")
    private String batch;

    /**
     * 活动ID，如果是活动商品的必传，   普通商品不传
     */
    @ApiModelProperty(name = "activityId", value = "活动ID，如果是活动商品的，必传，普通商品，不传")
    private Long activityId;
    @ApiModelProperty(name = "tradeOrderItemId", value = "商品行明细id")
    private Long tradeOrderItemId;
    /**
     * 变动库存
     */
    @ApiModelProperty(name = "changeInventory", value = "变动库存")
    private BigDecimal changeInventory;

    @ApiModelProperty(name = "cargoProportion", value = "比例,此活动在此活动里占的比例,此货品活动总库存 = 活动套数 x 此货品比例")
    private BigDecimal cargoProportion;

    @ApiModelProperty(name = "produceTime", value = "生产日期")
    private Date produceTime;

    @ApiModelProperty(name = "expireTime", value = "过期日期")
    private Date expireTime;

    /**
     * 是否覆盖原有库存 cover-覆盖  update-更新(默认)
     */
    @ApiModelProperty(name = "coverInventoryFlag", value = "是否覆盖原有库存 cover-覆盖  update-更新(默认)")
    private String coverInventoryFlag = CsInventoryCoverInventoryFlagEnum.UPDATE.getCode();

    public String getCoverInventoryFlag() {
        coverInventoryFlag = null == CsInventoryCoverInventoryFlagEnum.getByCode(coverInventoryFlag) ? CsInventoryCoverInventoryFlagEnum.UPDATE.getCode() : coverInventoryFlag;
        return coverInventoryFlag;
    }

    public Long getTradeOrderItemId() {
        return tradeOrderItemId;
    }

    public void setTradeOrderItemId(Long tradeOrderItemId) {
        this.tradeOrderItemId = tradeOrderItemId;
    }

    public void setCoverInventoryFlag(String coverInventoryFlag) {
        this.coverInventoryFlag = coverInventoryFlag;
    }

    public Date getProduceTime() {
        return produceTime;
    }

    public void setProduceTime(Date produceTime) {
        this.produceTime = produceTime;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public CsInventoryOperateCargoReqDto() {

    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public BigDecimal getChangeInventory() {
        return changeInventory;
    }

    public void setChangeInventory(BigDecimal changeInventory) {
        this.changeInventory = changeInventory;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public BigDecimal getCargoProportion() {
        return cargoProportion;
    }

    public void setCargoProportion(BigDecimal cargoProportion) {
        this.cargoProportion = cargoProportion;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }
}
