package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import com.dtyunxi.yundt.cube.center.inventory.enums.YesNoEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 库存操作请求DTO
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/18 2:21 下午
 */
@ApiModel(value = "csInventoryOperateReqDto", description = "库存操作请求DTO")
public class CsInventoryOperateReqDto implements Serializable {

    /**
     * 平台单号
     * 主要用于销售订单的渠道仓库存预占
     * 针对于外部销售订单，可能是先从第三方发起预占，然后再推单下来进行预占，预占的时候，子订单
     * 拆单完毕，不能重复预占
     */
    @ApiModelProperty(name = "platformOrderNo", value = "平台单号")
    private String platformOrderNo;

    /**
     * 来源单据号
     */
    @ApiModelProperty(name = "sourceNo", value = "来源单据号")
    private String sourceNo;

    /**
     * 来源单据类型 com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum
     */
    @ApiModelProperty(name = "sourceType", value = "来源单据类型")
    private String sourceType;

    /**
     * 来源业务类型 com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum
     **/
    @ApiModelProperty(name = "businessType", value = "来源业务类型")
    private String businessType;

    /**
     * 是否校验负库存  0-不校验，允许负库存     1-校验(默认)，不允许负库存
     */
    @ApiModelProperty(name = "negativeValidate", value = "是否校验负库存  0-不校验，允许负库存     1-校验(默认)，不允许负库存")
    private Integer negativeValidate;

    /**
     * 货品明细
     */
    @ApiModelProperty(name = "operateCargoReqDtoList", value = "货品明细")
    private List<CsInventoryOperateCargoReqDto> operateCargoReqDtoList;

    /**
     * 出入库标识  in-入库  out-出库   com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum
     * 对于库存中心底层操作需要用到，库存中心暴露给其他中心的接口或者应用层的接口，代码逻辑里会做处理，可以不传，
     * 但是如果是直接操作库存中心底层的，需要传入
     */
    @ApiModelProperty(name = "inOutFlag", value = "出入库标识  in-入库  out-出库")
    private String inOutFlag;

    /**
     * 操作批次表的时候，是否同步更新总表  0-不更新（默认）  1-更新
     **/
    @ApiModelProperty(name = "updateTotalFlag", value = "操作批次表的时候，是否同步更新总表  0-不更新（默认）  1-更新")
    private Integer updateTotalFlag = YesNoEnum.NO.getValue();

    /**
     * 额外的操作字段
     **/
    @ApiModelProperty(name = "extension", value = "额外的操作字段")
    private String extension;

    /**
     * 是否计算批次，也就是某些业务场景下，操作预占的时候，是不带批次的,
     * 此时需要根据已有的批次，将可用库存进行排序（由大到小）后，逐个往下
     * 进行预占
     **/
    @ApiModelProperty(name = "batchCalculate", value = "是否计算批次，true = 计算  false = 不计算(默认)")
    private Boolean batchCalculate = false;

    /**
     * 库存策略,外部可不关注此字段
     */
    @ApiModelProperty(name = "inventoryStrategy", value = "库存策略,外部可不关注此字段")
    private String inventoryStrategy;

    /**
     * 操作版本来源，主要用于区分V1.0改造还是汤臣二期的  1-V1.0   2-二期
     */
    @ApiModelProperty(name = "operateVersion", value = "操作版本来源，主要用于区分V1.0改造还是汤臣二期的  1-V1.0   2-二期")
    private Integer operateVersion;

    /**
     * 库存释放后，是否需要将预占记录置为无效  true:默认需要释放     false:不释放
     **/
    @ApiModelProperty(name = "disablePreemptionFlag", value = "库存释放后，是否需要将预占记录置为无效  true:默认需要释放     false:不释放")
    private Boolean disablePreemptionFlag = true;

    /**
     * 渠道编码
     */
    @ApiModelProperty(name = "channelCode", value = "渠道编码")
    private String channelCode;

    @ApiModelProperty(name = "suffix", value = "操作后缀")
    private String suffix;

    /**
     * 需要释放的库存策略
     * com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum
     */
    @ApiModelProperty(name = "releaseStrategyList", value = "需要释放的库存策略")
    private List<String> releaseStrategyList;

    /**
     * 收货地址/发货地址
     **/
    @ApiModelProperty(name = "address", value = "收货地址/发货地址")
    private String address;

    /**
     * 联系人
     **/
    @ApiModelProperty(name = "address", value = "联系人")
    private String contactName;

    /**
     * 联系电话
     **/
    @ApiModelProperty(name = "contactPhone", value = "联系电话")
    private String contactPhone;

    /**
     * 计划发货/收货时间
     **/
    @ApiModelProperty(name = "planTime", value = "计划发货/收货时间")
    private String planTime;

    @ApiModelProperty(name="sourceSystem",value = "来源系统")
    private String sourceSystem;

    @ApiModelProperty(name = "relevanceNo", value = "关联单号（内部使用，外部无需处理）")
    private String relevanceNo;
    @ApiModelProperty(name = "logicWarehouseCode", value = "逻辑仓编码（内部使用，外部无需处理）")
    private String logicWarehouseCode;

    @ApiModelProperty(name = "logicWarehouseName", value = "逻辑仓名称（内部使用，外部无需处理）")
    private String logicWarehouseName;

    @ApiModelProperty(name = "logicWarehouseCode", value = "物理仓编码（内部使用，外部无需处理）")
    private String physicsWarehouseCode;

    @ApiModelProperty(name = "physicsWarehouseName", value = "物理仓名称（内部使用，外部无需处理）")
    private String physicsWarehouseName;

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getContactName() {
        return contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public String getPlanTime() {
        return planTime;
    }

    public void setPlanTime(String planTime) {
        this.planTime = planTime;
    }

    public String getSourceSystem() {
        return sourceSystem;
    }

    public void setSourceSystem(String sourceSystem) {
        this.sourceSystem = sourceSystem;
    }

    public String getLogicWarehouseCode() {
        return logicWarehouseCode;
    }

    public String getRelevanceNo() {
        return relevanceNo;
    }

    public void setRelevanceNo(String relevanceNo) {
        this.relevanceNo = relevanceNo;
    }

    public void setLogicWarehouseCode(String logicWarehouseCode) {
        this.logicWarehouseCode = logicWarehouseCode;
    }

    public String getLogicWarehouseName() {
        return logicWarehouseName;
    }

    public void setLogicWarehouseName(String logicWarehouseName) {
        this.logicWarehouseName = logicWarehouseName;
    }

    public String getPhysicsWarehouseCode() {
        return physicsWarehouseCode;
    }

    public void setPhysicsWarehouseCode(String physicsWarehouseCode) {
        this.physicsWarehouseCode = physicsWarehouseCode;
    }

    public String getPhysicsWarehouseName() {
        return physicsWarehouseName;
    }

    public void setPhysicsWarehouseName(String physicsWarehouseName) {
        this.physicsWarehouseName = physicsWarehouseName;
    }

    public CsInventoryOperateReqDto() {
    }

    public String getSourceNo() {
        return sourceNo;
    }

    public void setSourceNo(String sourceNo) {
        this.sourceNo = sourceNo;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Integer getNegativeValidate() {
        return negativeValidate;
    }

    public void setNegativeValidate(Integer negativeValidate) {
        this.negativeValidate = negativeValidate;
    }

    public List<CsInventoryOperateCargoReqDto> getOperateCargoReqDtoList() {
        return operateCargoReqDtoList;
    }

    public void setOperateCargoReqDtoList(List<CsInventoryOperateCargoReqDto> operateCargoReqDtoList) {
        this.operateCargoReqDtoList = operateCargoReqDtoList;
    }

    public String getInOutFlag() {
        return inOutFlag;
    }

    public void setInOutFlag(String inOutFlag) {
        this.inOutFlag = inOutFlag;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getInventoryStrategy() {
        return inventoryStrategy;
    }

    public void setInventoryStrategy(String inventoryStrategy) {
        this.inventoryStrategy = inventoryStrategy;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public Boolean getBatchCalculate() {
        return batchCalculate;
    }

    public void setBatchCalculate(Boolean batchCalculate) {
        this.batchCalculate = batchCalculate;
    }

    public Integer getOperateVersion() {
        return operateVersion;
    }

    public void setOperateVersion(Integer operateVersion) {
        this.operateVersion = operateVersion;
    }

    public Boolean getDisablePreemptionFlag() {
        return disablePreemptionFlag;
    }

    public void setDisablePreemptionFlag(Boolean disablePreemptionFlag) {
        this.disablePreemptionFlag = disablePreemptionFlag;
    }

    public Integer getUpdateTotalFlag() {
        return updateTotalFlag;
    }

    public void setUpdateTotalFlag(Integer updateTotalFlag) {
        this.updateTotalFlag = updateTotalFlag;
    }

    public String getPlatformOrderNo() {
        return platformOrderNo;
    }

    public void setPlatformOrderNo(String platformOrderNo) {
        this.platformOrderNo = platformOrderNo;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getSuffix() {
        return suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public List<String> getReleaseStrategyList() {
        return releaseStrategyList;
    }

    public void setReleaseStrategyList(List<String> releaseStrategyList) {
        this.releaseStrategyList = releaseStrategyList;
    }
}
