package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.base.ContactDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 销售退请求DTO
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/5/19 9:43 上午
 */
@ApiModel(value = "csInventoryOrderSalesRefundReqDto", description = "销售退请求DTO")
public class CsInventoryOrderSalesRefundReqDto implements Serializable {
    /**
     * 来源单据号
     */
    @ApiModelProperty(name = "sourceNo", value = "来源单据号")
    private String sourceNo;

    /**
     * 销售退单商品总数量
     */
    @ApiModelProperty(name = "totalInventory", value = "销售退单商品总数量")
    private BigDecimal totalInventory;

    /**
     * 商品明细
     */
    @ApiModelProperty(name = "operateCargoReqDtoList", value = "商品明细")
    private List<CsInventoryOrderSalesRefundDetailReqDto> operateCargoReqDtoList;

    //----------------------------外部无需关注字段
    /**
     * 是否推送WSM
     * 无需关注此字段
     */
    @ApiModelProperty(name = "sendWmsFlag", value = "是否推送WSM")
    private Boolean sendWmsFlag;

    @ApiModelProperty(name = "sourceSystem", value = "来源系统")
    private String sourceSystem;


    /**
     * 收货地址/发货地址信息
     **/
    @ApiModelProperty(name = "contactDto", value = "收货地址/发货地址信息")
    private ContactDto contactDto;

    public ContactDto getContactDto() {
        return contactDto;
    }

    public void setContactDto(ContactDto contactDto) {
        this.contactDto = contactDto;
    }

    public String getSourceSystem() {
        return sourceSystem;
    }

    public void setSourceSystem(String sourceSystem) {
        this.sourceSystem = sourceSystem;
    }

    public String getSourceNo() {
        return sourceNo;
    }

    public void setSourceNo(String sourceNo) {
        this.sourceNo = sourceNo;
    }

    public BigDecimal getTotalInventory() {
        return totalInventory;
    }

    public void setTotalInventory(BigDecimal totalInventory) {
        this.totalInventory = totalInventory;
    }

    public List<CsInventoryOrderSalesRefundDetailReqDto> getOperateCargoReqDtoList() {
        return operateCargoReqDtoList;
    }

    public void setOperateCargoReqDtoList(List<CsInventoryOrderSalesRefundDetailReqDto> operateCargoReqDtoList) {
        this.operateCargoReqDtoList = operateCargoReqDtoList;
    }

    public Boolean getSendWmsFlag() {
        return sendWmsFlag;
    }

    public void setSendWmsFlag(Boolean sendWmsFlag) {
        this.sendWmsFlag = sendWmsFlag;
    }
}
