package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 根据预占操作释放操作请求DTO
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/18 2:21 下午
 */
@ApiModel(value = "CsInventoryReleasePreemptOperateReqDto",description = "根据预占操作释放操作请求DTO")
public class CsInventoryReleasePreemptOperateReqDto implements Serializable {
    /**
     * 来源单据号
     */
    @ApiModelProperty(name="sourceNo",value = "来源单据号")
    private String sourceNo;

    /**
     * 来源单据类型 com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum
     * 也就是本次进行操作释放的类型，比如订单取消释放
     */
    @ApiModelProperty(name="sourceType",value = "来源单据类型")
    private String sourceType;

    /**
     * 库存策略
     */
    @ApiModelProperty(name="inventoryStrategy",value = "库存策略")
    private String inventoryStrategy;

    /**
     * 货品明细，可以不指定，如果不指定，则会通过sourceNo单号查询出预占记录，进行整单释放
     * 如果传入，则限制只查询出对应条件的预占记录，并且进行释放
     */
    @ApiModelProperty(name="operateCargoReqDtoList",value = "货品明细，可以不指定，如果不指定，则会通过sourceNo单号查询出预占记录，进行整单释放\n" +
            "     * 如果传入，则限制只查询出对应条件的预占记录，并且进行释放")
    private List<CsInventoryOperateCargoReqDto> operateCargoReqDtoList;

    /**
     * 查询预占记录时，限制必须为哪些类型的预占才查询出来并且进行预占 com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum
     */
    @ApiModelProperty(name="includeSourceTypeList",value = "查询预占记录时，限制必须为哪些类型的预占才查询出来并且进行预占")
    private List<String> includeSourceTypeList;

    /**
     * 活动标识
     */
    @ApiModelProperty(name="activityFlag",value = "活动标识")
    private Integer activityFlag;

    public CsInventoryReleasePreemptOperateReqDto() {
    }

    public String getSourceNo() {
        return sourceNo;
    }

    public void setSourceNo(String sourceNo) {
        this.sourceNo = sourceNo;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public List<CsInventoryOperateCargoReqDto> getOperateCargoReqDtoList() {
        return operateCargoReqDtoList;
    }

    public void setOperateCargoReqDtoList(List<CsInventoryOperateCargoReqDto> operateCargoReqDtoList) {
        this.operateCargoReqDtoList = operateCargoReqDtoList;
    }

    public List<String> getIncludeSourceTypeList() {
        return includeSourceTypeList;
    }

    public void setIncludeSourceTypeList(List<String> includeSourceTypeList) {
        this.includeSourceTypeList = includeSourceTypeList;
    }

    public String getInventoryStrategy() {
        return inventoryStrategy;
    }

    public void setInventoryStrategy(String inventoryStrategy) {
        this.inventoryStrategy = inventoryStrategy;
    }

    public Integer getActivityFlag() {
        return activityFlag;
    }

    public void setActivityFlag(Integer activityFlag) {
        this.activityFlag = activityFlag;
    }
}
