package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
* 库存盘点单导入
*
* @author 宁毅
* @since 2022-04-25
*/
@ApiModel(value = "CsInventoryTakeStockImportDto", description = "导入dto")
public class CsInventoryTakeStockImportDto implements Serializable {
    /**
     *  仓库类型（1:逻辑仓 2:物理仓）
     */
    @ApiModelProperty(name = "warehouseType", value = "仓库类型（1:逻辑仓 2:物理仓）")
    private Integer warehouseType;
    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;

    /** 账面时间 需要传String类型格式2022-04-27*/
    @ApiModelProperty(name="balanceDate",value = "账面时间 需要传String类型格式2022-04-27")
    private String balanceDate;

    /**
     *  导入文件地址
     */
    @ApiModelProperty(name = "url", value = "导入文件地址")
    private String url;

    public Integer getWarehouseType() {
        return warehouseType;
    }

    public void setWarehouseType(Integer warehouseType) {
        this.warehouseType = warehouseType;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getBalanceDate() {
        return balanceDate;
    }

    public void setBalanceDate(String balanceDate) {
        this.balanceDate = balanceDate;
    }
}
