package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
* 库存盘点单商品信息Eo对象
*
* @author 宁毅
* @since 2022-04-25
*/
@ApiModel(value = "CsInventoryTakeStockOrderItemReqDto", description = "库存盘点单商品信息Eo对象")
public class CsInventoryTakeStockOrderItemReqDto extends RequestDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  单据号,关联的盘点单据号
    */
    @ApiModelProperty(name = "orderNo", value = "单据号,关联的盘点单据号")
    private String orderNo;
    /**
    *  货品ID
    */
    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;
    /**
    *  商品长编码
    */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    /**
    *  货品编码
    */
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;
    /**
    *  货品名称
    */
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;
    /**
    *  货品货号
    */
    @ApiModelProperty(name = "artNo", value = "货品货号")
    private String artNo;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  过期日期
    */
    @ApiModelProperty(name = "expireTime", value = "过期日期")
    private Date expireTime;
    /**
    *  生产日期
    */
    @ApiModelProperty(name = "produceTime", value = "生产日期")
    private Date produceTime;
    /**
    *  账面数量
    */
    @ApiModelProperty(name = "accountNum", value = "账面数量")
    private Integer accountNum;
    /**
    *  实盘数量
    */
    @ApiModelProperty(name = "firmOfferNum", value = "实盘数量")
    private Integer firmOfferNum;
    /**
    *  差异数
    */
    @ApiModelProperty(name = "differenceNum", value = "差异数")
    private Integer differenceNum;
    /**
    *  盘点类型（1:盘盈 2:盘亏）
    */
    @ApiModelProperty(name = "takeStockType", value = "盘点类型（1:盘盈 2:盘亏 3:不处理）")
    private Integer takeStockType;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  组织ID
    */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
    *  组织名称
    */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setOrderNo(String orderNo){
    this.orderNo = orderNo;
    }
    public String getOrderNo(){
    return this.orderNo;
    }
    public void setCargoId(Long cargoId){
    this.cargoId = cargoId;
    }
    public Long getCargoId(){
    return this.cargoId;
    }
    public void setLongCode(String longCode){
    this.longCode = longCode;
    }
    public String getLongCode(){
    return this.longCode;
    }
    public void setCargoCode(String cargoCode){
    this.cargoCode = cargoCode;
    }
    public String getCargoCode(){
    return this.cargoCode;
    }
    public void setCargoName(String cargoName){
    this.cargoName = cargoName;
    }
    public String getCargoName(){
    return this.cargoName;
    }
    public void setArtNo(String artNo){
    this.artNo = artNo;
    }
    public String getArtNo(){
    return this.artNo;
    }
    public void setBatch(String batch){
    this.batch = batch;
    }
    public String getBatch(){
    return this.batch;
    }
    public void setExpireTime(Date expireTime){
    this.expireTime = expireTime;
    }
    public Date getExpireTime(){
    return this.expireTime;
    }
    public void setProduceTime(Date produceTime){
    this.produceTime = produceTime;
    }
    public Date getProduceTime(){
    return this.produceTime;
    }
    public void setAccountNum(Integer accountNum){
    this.accountNum = accountNum;
    }
    public Integer getAccountNum(){
    return this.accountNum;
    }
    public void setFirmOfferNum(Integer firmOfferNum){
    this.firmOfferNum = firmOfferNum;
    }
    public Integer getFirmOfferNum(){
    return this.firmOfferNum;
    }
    public void setDifferenceNum(Integer differenceNum){
    this.differenceNum = differenceNum;
    }
    public Integer getDifferenceNum(){
    return this.differenceNum;
    }
    public void setTakeStockType(Integer takeStockType){
    this.takeStockType = takeStockType;
    }
    public Integer getTakeStockType(){
    return this.takeStockType;
    }
    public void setRemark(String remark){
    this.remark = remark;
    }
    public String getRemark(){
    return this.remark;
    }
    public void setOrganizationId(Long organizationId){
    this.organizationId = organizationId;
    }
    public Long getOrganizationId(){
    return this.organizationId;
    }
    public void setOrganizationName(String organizationName){
    this.organizationName = organizationName;
    }
    public String getOrganizationName(){
    return this.organizationName;
    }
}
