package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
* 库存盘点单Eo对象
*
* @author 宁毅
* @since 2022-04-25
*/
@ApiModel(value = "CsInventoryTakeStockOrderQueryDto", description = "查询dto")
public class CsInventoryTakeStockOrderQueryDto extends RequestDto{
    /**
    *  单据号,系统生成的盘点单据号
    */
    @ApiModelProperty(name = "orderNo", value = "单据号,系统生成的盘点单据号 模糊匹配")
    private String orderNo;
    /**
    *  业务类型（1:抽盘 2:全盘）
    */
    @ApiModelProperty(name = "bizType", value = "业务类型（1:抽盘 2:全盘）精准匹配")
    private Integer bizType;
    /**
    *  单据状态:wait_submit-待提交,wait_audit-待审核,audit_failed-审核不通过,cancel-已取消,completed-已完成,execution _failed-执行失败
    */
    @ApiModelProperty(name = "orderStatus", value = "单据状态:wait_submit-待提交,wait_audit-待审核,audit_failed-审核不通过,cancel-已取消,completed-已完成,execution _failed-执行失败 精准匹配")
    private String orderStatus;
    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;

    /**
     *  仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称 模糊匹配")
    private String warehouseName;

    /**
     *  开始时间
     */
    @ApiModelProperty(name = "beginTime", value = "开始时间")
    private String beginTime;
    /**
     *  结束时间
     */
    @ApiModelProperty(name = "endTime", value = "结束时间")
    private String endTime;

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;

    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;

    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照createTime降序")
    private String orderByDesc = "create_time";

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Integer getBizType() {
        return bizType;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }
}
