package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;

/**
* 库存盘点单Eo对象
*
* @author 宁毅
* @since 2022-04-25
*/
@ApiModel(value = "CsInventoryTakeStockOrderReqDto", description = "库存盘点单Eo对象")
public class CsInventoryTakeStockOrderReqDto extends RequestDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  单据号,系统生成的盘点单据号
    */
    @ApiModelProperty(name = "orderNo", value = "单据号,系统生成的盘点单据号")
    private String orderNo;
    /**
    *  业务类型（1:抽盘 2:全盘）
    */
    @ApiModelProperty(name = "bizType", value = "业务类型（1:抽盘 2:全盘）")
    private Integer bizType;
    /**
    *  单据状态:wait_submit-待提交,wait_audit-待审核,audit_failed-审核不通过,cancel-已取消,completed-已完成,execution _failed-执行失败
    */
    @ApiModelProperty(name = "orderStatus", value = "单据状态:wait_submit-待提交,wait_audit-待审核,audit_failed-审核不通过,cancel-已取消,completed-已完成,execution _failed-执行失败")
    private String orderStatus;
    /**
    *  仓库类型（1:逻辑仓 2:物理仓）
    */
    @ApiModelProperty(name = "warehouseType", value = "仓库类型（1:逻辑仓 2:物理仓）")
    private Integer warehouseType;
    /**
    *  仓库ID
    */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
    *  仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
    *  账面时间
    */
    @ApiModelProperty(name = "String", value = "账面时间")
    private String accountTime;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  组织ID
    */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
    *  组织名称
    */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    /**
     *  盘点单商品信息
     */
    @ApiModelProperty(name = "takeStockOrderItemReqDtoList", value = "盘点单商品信息")
    private List<CsInventoryTakeStockOrderItemReqDto> takeStockOrderItemReqDtoList;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setOrderNo(String orderNo){
    this.orderNo = orderNo;
    }
    public String getOrderNo(){
    return this.orderNo;
    }
    public void setBizType(Integer bizType){
    this.bizType = bizType;
    }
    public Integer getBizType(){
    return this.bizType;
    }
    public void setOrderStatus(String orderStatus){
    this.orderStatus = orderStatus;
    }
    public String getOrderStatus(){
    return this.orderStatus;
    }
    public void setWarehouseType(Integer warehouseType){
    this.warehouseType = warehouseType;
    }
    public Integer getWarehouseType(){
    return this.warehouseType;
    }
    public void setWarehouseId(Long warehouseId){
    this.warehouseId = warehouseId;
    }
    public Long getWarehouseId(){
    return this.warehouseId;
    }
    public void setWarehouseCode(String warehouseCode){
    this.warehouseCode = warehouseCode;
    }
    public String getWarehouseCode(){
    return this.warehouseCode;
    }
    public void setWarehouseName(String warehouseName){
    this.warehouseName = warehouseName;
    }
    public String getWarehouseName(){
    return this.warehouseName;
    }

    public String getAccountTime() {
        return accountTime;
    }

    public void setAccountTime(String accountTime) {
        this.accountTime = accountTime;
    }

    public void setRemark(String remark){
    this.remark = remark;
    }
    public String getRemark(){
    return this.remark;
    }
    public void setOrganizationId(Long organizationId){
    this.organizationId = organizationId;
    }
    public Long getOrganizationId(){
    return this.organizationId;
    }
    public void setOrganizationName(String organizationName){
    this.organizationName = organizationName;
    }
    public String getOrganizationName(){
    return this.organizationName;
    }

    public List<CsInventoryTakeStockOrderItemReqDto> getTakeStockOrderItemReqDtoList() {
        return takeStockOrderItemReqDtoList;
    }

    public void setTakeStockOrderItemReqDtoList(List<CsInventoryTakeStockOrderItemReqDto> takeStockOrderItemReqDtoList) {
        this.takeStockOrderItemReqDtoList = takeStockOrderItemReqDtoList;
    }
}
