package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 逻辑仓商品查询dto
 *
 * @author wuyue
 * @since 2022-04-25
 */
@ApiModel(value = "CsInventoryTotalQueryReqDto", description = "逻辑仓商品查询dto")
public class CsInventoryTotalQueryReqDto implements Serializable {

    /**
     * 商品长编码
     */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;

    /**
     * 逻辑仓编码
     */
    @ApiModelProperty(name = "logicWarehouseCode", value = "逻辑仓编码")
    private String logicWarehouseCode;

    @ApiModelProperty(name = "logicWarehouseCodeList", value = "逻辑仓编码集合")
    private List<String> logicWarehouseCodeList = new ArrayList<>();

    /**
     * 商品名称
     */
    @ApiModelProperty(name = "cargoName", value = "商品名称")
    private String cargoName;

    /**
     * 商品长编码集合
     */
    @ApiModelProperty(name = "longCodeList", value = "商品长编码集合")
    private List<String> longCodeList = new ArrayList<>();

    private Integer pageNum;
    private Integer pageSize;


    public List<String> getLogicWarehouseCodeList() {
        return logicWarehouseCodeList;
    }

    public void setLogicWarehouseCodeList(List<String> logicWarehouseCodeList) {
        this.logicWarehouseCodeList = logicWarehouseCodeList;
    }

    public List<String> getLongCodeList() {
        return longCodeList;
    }

    public void setLongCodeList(List<String> longCodeList) {
        this.longCodeList = longCodeList;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public String getLogicWarehouseCode() {
        return logicWarehouseCode;
    }

    public void setLogicWarehouseCode(String logicWarehouseCode) {
        this.logicWarehouseCode = logicWarehouseCode;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}