/**
 * @(#)CsLogicInventoryRespDto.java 1.0 2021/12/29 11:11
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @author jingran
 * @Description CsLogicInventoryRespDto
 * @Date: 2021/12/29 11:11
 * @since 1.0.0
 */
@ApiModel(value = "CsInventoryWarehouseQueryReqDto", description = "返回信息Dto")
public class CsInventoryWarehouseQueryReqDto implements Serializable {

    /**
     * 货权组织编码
     **/
    @ApiModelProperty(name = "cargoEscheatageCode", value = "货权组织编码")
    private String cargoEscheatageCode;

    /**
     * 查询库存策略选择   com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum
     *
     * 默认：逻辑仓logic
     */
    @ApiModelProperty(name = "inventoryStrategy", value = "查询库存策略选择,com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum")
    private String inventoryStrategy;

    /**
     * 批次
     **/
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;

    /**
     * 商品长编码
     **/
    @ApiModelProperty(name = "longCode", value = "长编码")
    private String longCode;

    public CsInventoryWarehouseQueryReqDto() {
    }

    public String getInventoryStrategy() {
        return inventoryStrategy;
    }

    public void setInventoryStrategy(String inventoryStrategy) {
        this.inventoryStrategy = inventoryStrategy;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public String getCargoEscheatageCode() {
        return cargoEscheatageCode;
    }

    public void setCargoEscheatageCode(String cargoEscheatageCode) {
        this.cargoEscheatageCode = cargoEscheatageCode;
    }
}
