/**
 * @(#)CsLockLogQueryDto.java 1.0 2022/05/30 15:49
 * <p>
 * Copyright (c) 2022, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
* @Description CsLockLogQueryDto
*
* @author wenyi
* @Date: 2022/05/30 15:49
* @since 1.0.0
*/
@ApiModel(value = "csLockLogQueryDto", description = "查询Dto")
public class CsLockLogQueryDto implements Serializable {

    /** 锁库单号 */
    @ApiModelProperty(name="documentNo",value = "锁库单号")
    private String documentNo;
    /** 类型：lock 锁库，unlock 解锁 */
    @ApiModelProperty(name="type",value = "类型：lock 锁库，unlock 解锁")
    private String type;
    /** 逻辑仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "逻辑仓库编码")
    private String warehouseCode;
    /** 逻辑仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "逻辑仓库名称")
    private String warehouseName;
    /** 商品长编码 */
    @ApiModelProperty(name="longCode",value = "商品长编码")
    private String longCode;
    /** 货品编码 */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;
    /** 货品名称 */
    @ApiModelProperty(name="cargoName",value = "货品名称")
    private String cargoName;
    /** 货品货号 */
    @ApiModelProperty(name="artNo",value = "货品货号")
    private String artNo;
    /** 批次 */
    @ApiModelProperty(name="batch",value = "批次")
    private String batch;
    /** 当前锁库/解锁数量 */
    @ApiModelProperty(name="currentQuantity",value = "当前锁库/解锁数量")
    private BigDecimal currentQuantity;
    /** 锁库原因 */
    @ApiModelProperty(name="remark",value = "锁库原因")
    private String remark;
    /** 过期日期 */
    @ApiModelProperty(name="expireTime",value = "过期日期")
    private Date expireTime;
    /** 生产日期 */
    @ApiModelProperty(name="produceTime",value = "生产日期")
    private Date produceTime;
    /** 组织ID */
    @ApiModelProperty(name="organizationId",value = "组织ID")
    private Long organizationId;
    /** 组织code */
    @ApiModelProperty(name="organizationCode",value = "组织code")
    private String organizationCode;
    /** 所属组织名称 */
    @ApiModelProperty(name="organizationName",value = "所属组织名称")
    private String organizationName;
    /** 起始创建时间 */
    @ApiModelProperty(name = "beginCreateTime", value = "起始创建时间 格式: yyyy-MM-dd HH:mm:ss")
    private String beginCreateTime;
    /** 结束创建时间 */
    @ApiModelProperty(name = "endCreateTime", value = "结束创建时间 格式: yyyy-MM-dd HH:mm:ss")
    private String endCreateTime;
    /** 日志状态：normal正常，abnormal异常 */
    @ApiModelProperty(name = "logStatus", value = "日志状态：normal正常，abnormal异常")
    private String logStatus;
    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;
    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;
    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照createTime降序")
    private String orderByDesc = "createTime";
    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public BigDecimal getCurrentQuantity() {
        return currentQuantity;
    }

    public void setCurrentQuantity(BigDecimal currentQuantity) {
        this.currentQuantity = currentQuantity;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Date getProduceTime() {
        return produceTime;
    }

    public void setProduceTime(Date produceTime) {
        this.produceTime = produceTime;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getBeginCreateTime() {
        return beginCreateTime;
    }

    public void setBeginCreateTime(String beginCreateTime) {
        this.beginCreateTime = beginCreateTime;
    }

    public String getEndCreateTime() {
        return endCreateTime;
    }

    public void setEndCreateTime(String endCreateTime) {
        this.endCreateTime = endCreateTime;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }

    public String getLogStatus() {
        return logStatus;
    }

    public void setLogStatus(String logStatus) {
        this.logStatus = logStatus;
    }
}