/**
 * @(#)CsLockOrderAddReqDto.java 1.0 2022/05/30 15:48
 * <p>
 * Copyright (c) 2022, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
* @Description CsLockOrderAddReqDto
*
* @author wenyi
* @Date: 2022/05/30 15:48
* @since 1.0.0
*/
@ApiModel(value = "csLockOrderAddReqDto", description = "新增Dto")
public class CsLockOrderAddReqDto implements Serializable {

    /** 逻辑仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "逻辑仓库编码")
    private String warehouseCode;
    /** 商品长编码 */
    @ApiModelProperty(name="longCode",value = "商品长编码")
    private String longCode;
    /** 货品编码 */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;
    /** 货品名称 */
    @ApiModelProperty(name="cargoName",value = "货品名称")
    private String cargoName;
    /** 货品货号 */
    @ApiModelProperty(name="artNo",value = "货品货号")
    private String artNo;
    /** 批次 */
    @ApiModelProperty(name="batch",value = "批次")
    private String batch;
    /** 当前锁库数量 */
    @ApiModelProperty(name="currentLockQuantity",value = "当前锁库数量")
    private BigDecimal currentLockQuantity;
    /** 人工锁库次数 */
    @ApiModelProperty(name="number",value = "人工锁库次数")
    private Integer number;
    /** 锁库原因 */
    @ApiModelProperty(name="remark",value = "锁库原因")
    private String remark;

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public BigDecimal getCurrentLockQuantity() {
        return currentLockQuantity;
    }

    public void setCurrentLockQuantity(BigDecimal currentLockQuantity) {
        this.currentLockQuantity = currentLockQuantity;
    }

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

}