/**
 * @(#)CsLockOrderUpdateReqDto.java 1.0 2022/05/30 15:48
 * <p>
 * Copyright (c) 2022, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author wenyi
 * @Description CsLockOrderUpdateReqDto
 * @Date: 2022/05/30 15:48
 * @since 1.0.0
 */
@Data
@ApiModel(value = "csLockOrderUpdateReqDto", description = "修改Dto")
public class CsLockOrderUpdateReqDto implements Serializable {
    /**
     * 逻辑仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "逻辑仓库编码")
    private String warehouseCode;
    /**
     * 商品长编码
     */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    /**
     * 商品编码
     */
    @ApiModelProperty(name = "cargoCode", value = "商品编码")
    private String cargoCode;
    /**
     * 批次
     */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
     * 当前锁库/解锁数量
     */
    @ApiModelProperty(name = "currentLockQuantity", value = "当前锁库/解锁数量")
    private BigDecimal currentLockQuantity;
    /**
     * 操作原因
     */
    @ApiModelProperty(name = "remark", value = "操作原因")
    private String remark;
    /**
     * 是否临期(中心用到，默认更新不是临期的商品，应用层忽略)：1是，0否
     */
    @ApiModelProperty(name = "isNearOverdue", value = "是否临期(中心用到，默认更新不是临期的商品)：1是，0否")
    private Integer isNearOverdue;
    /**
     * 创建人(中心用到，应用层忽略)
     */
    @ApiModelProperty(name = "createPerson", value = "创建人")
    private String createPerson;
    /**
     * 锁库单号(中心用到，应用层忽略)
     */
    @ApiModelProperty(name = "documentNo", value = "锁库单号(中心用到，应用层忽略)")
    private String documentNo;

    @ApiModelProperty(name = "lockAll", value = "是否整单处理：false-按指定数量，ture-全量处理")
    private Boolean lockAll=false;

    private String warehouseName;

    private Date expireTime;

    private Date produceTime;


    private String cargoName;

    private String artNo;

    private Long organizationId;

    private String organizationCode;

    private String organizationName;

    private String logStatus;

}