/**
 * @(#)CsLogicInventoryQueryDto.java 1.0 2021/12/29 11:11
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * @author jingran
 * @Description CsLogicInventoryQueryDto
 * @Date: 2021/12/29 11:11
 * @since 1.0.0
 */
@ApiModel(value = "csLogicInventoryQueryDto", description = "查询Dto")
public class CsLogicInventoryQueryDto implements Serializable {

    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;

    /**
     * 仓库编码集合
     */
    @ApiModelProperty(name = "warehouseCodeList", value = "仓库编码集合")
    private List<String> warehouseCodeList;
    /**
     * 货品ID
     */
    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;


    /**
     * 货品编码
     */
    @ApiModelProperty(name = "cargoCodeList", value = "货品编码列表")
    private List<String> cargoCodeList;


    /**
     * 货品编码
     */
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;
    @ApiModelProperty(name = "artNo", value = "货品货号")
    private String artNo;
    /**
     * 批次
     */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
     * 批次集合
     */
    @ApiModelProperty(name = "batchList", value = "批次集合")
    private List<String> batchList;
    /**
     * 批次类型 common-正常,defective-残次品,其他类型待定
     */
    @ApiModelProperty(name = "batchType", value = "批次类型 common-正常,defective-残次品,其他类型待定")
    private String batchType;
    /**
     * 货品长编码
     */
    @ApiModelProperty(name = "longCode", value = "货品长编码")
    private String longCode;

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;
    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;
    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照create_time降序")
    private String orderByDesc = "create_time";


    @ApiModelProperty(name = "filterLongCodes", value = "过滤长编码")
    private List<String> filterLongCodes;
    @ApiModelProperty(name = "unLikeBatch", value = "过滤批次")
    private String unLikeBatch;
    /**
     * 货品长编码集合
     */
    @ApiModelProperty(name = "longCodes", value = "货品长编码集合")
    private List<String> longCodes;

    @ApiModelProperty(name = "filterGtZero", required = true, value = "是否过滤可用大于0的记录：true-过滤，false/null-不过滤")
    private Boolean filterGtZero = false;

    @ApiModelProperty(name = "filterProduceTime", required = true, value = "是否过滤不存在生产日期的数据")
    private Boolean filterProduceTime = false;

    public List<String> getWarehouseCodeList() {
        return warehouseCodeList;
    }

    public void setWarehouseCodeList(List<String> warehouseCodeList) {
        this.warehouseCodeList = warehouseCodeList;
    }

    public List<String> getBatchList() {
        return batchList;
    }

    public void setBatchList(List<String> batchList) {
        this.batchList = batchList;
    }

    public Boolean getFilterGtZero() {
        return filterGtZero;
    }

    public void setFilterGtZero(Boolean filterGtZero) {
        this.filterGtZero = filterGtZero;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public List<String> getCargoCodeList() {
        return cargoCodeList;
    }

    public void setCargoCodeList(List<String> cargoCodeList) {
        this.cargoCodeList = cargoCodeList;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public String getBatchType() {
        return batchType;
    }

    public void setBatchType(String batchType) {
        this.batchType = batchType;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }

    public List<String> getLongCodes() {
        return longCodes;
    }

    public void setLongCodes(List<String> longCodes) {
        this.longCodes = longCodes;
    }

    public Boolean getFilterProduceTime() {
        return filterProduceTime;
    }

    public void setFilterProduceTime(Boolean filterProduceTime) {
        this.filterProduceTime = filterProduceTime;
    }


    public List<String> getFilterLongCodes() {
        return filterLongCodes;
    }

    public void setFilterLongCodes(List<String> filterLongCodes) {
        this.filterLongCodes = filterLongCodes;
    }

    public String getUnLikeBatch() {
        return unLikeBatch;
    }

    public void setUnLikeBatch(String unLikeBatch) {
        this.unLikeBatch = unLikeBatch;
    }
}