/**
 * @(#)CsLogicInventoryQueryDto.java 1.0 2021/12/29 11:11
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @author jingran
 * @Description CsLogicInventoryQueryDto
 * @Date: 2021/12/29 11:11
 * @since 1.0.0
 */
@ApiModel(value = "csLogicInventoryQueryOtherBatchDto", description = "分页查询除了入参的批次号的其他库存信息dto")
public class CsLogicInventoryQueryOtherBatchDto implements Serializable {

    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;

    /**
     * 排除的批次号
     */
    @ApiModelProperty(name = "excludeBatch", value = "排除的批次号")
    private String excludeBatch;

    /**
     * 模糊查询的批次号
     */
    @ApiModelProperty(name = "fuzzyQueryBatch", value = "模糊查询的批次")
    private String fuzzyQueryBatch;

    /**
     * 货品长编码
     */
    @ApiModelProperty(name = "longCode", value = "货品长编码")
    private String longCode;

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;
    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;
    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照create_time降序")
    private String orderByDesc = "create_time";

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getExcludeBatch() {
        return excludeBatch;
    }

    public void setExcludeBatch(String excludeBatch) {
        this.excludeBatch = excludeBatch;
    }

    public String getFuzzyQueryBatch() {
        return fuzzyQueryBatch;
    }

    public void setFuzzyQueryBatch(String fuzzyQueryBatch) {
        this.fuzzyQueryBatch = fuzzyQueryBatch;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }
}