/**
 * @(#)CsLogicInventoryTotalQueryDto.java 1.0 2022/01/12 09:18
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
* @Description CsLogicInventoryTotalQueryDto
*
* @author jingran
* @Date: 2022/01/12 09:18
* @since 1.0.0
*/
@ApiModel(value = "csLogicInventoryTotalQueryDto", description = "查询Dto")
@Data
public class CsLogicInventoryTotalQueryDto implements Serializable {

    /** 仓库ID */
    @ApiModelProperty(name="warehouseId",value = "仓库ID")
    private Long warehouseId;
    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;

    private List<String> warehouseCodes;
    /** 货品ID */
    @ApiModelProperty(name="cargoId",value = "货品ID")
    private Long cargoId;
    /** 货品编码 */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;

    private List<String> cargoCodes;
    /** 货品长编码 */
    @ApiModelProperty(name="longCode",value = "货品长编码")
    private String longCode;
    /** 总库存 */
    @ApiModelProperty(name="balance",value = "总库存")
    private BigDecimal balance;
    /** 预占库存 */
    @ApiModelProperty(name="preempt",value = "预占库存")
    private BigDecimal preempt;
    /** 已分配库存 */
    @ApiModelProperty(name="allocate",value = "已分配库存")
    private BigDecimal allocate;
    /** 活动分配库存 */
    @ApiModelProperty(name="activityAllocate",value = "活动分配库存")
    private BigDecimal activityAllocate;
    /** 在途库存 */
    @ApiModelProperty(name="intransit",value = "在途库存")
    private BigDecimal intransit;
    /** 已调拨库存 */
    @ApiModelProperty(name="transfer",value = "已调拨库存")
    private BigDecimal transfer;
    /** 已完成库存 */
    @ApiModelProperty(name="completed",value = "已完成库存")
    private BigDecimal completed;
    /** 可用库存,可用库存 = 总库存 + 在途库存  - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存 */
    @ApiModelProperty(name="available",value = "可用库存,可用库存 = 总库存 + 在途库存  - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存")
    private BigDecimal available;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;
    @ApiModelProperty(name = "artNo", value = "货品货号")
    private String artNo;
    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;
    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;
    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照create_time降序")
    private String orderByDesc = "create_time";
}