package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
* 物流信息表Eo对象
*
* @author 宁毅
* @since 2022-05-07
*/
@ApiModel(value = "CsLogisticsInfoReqDto", description = "物流信息表Eo对象")
public class CsLogisticsInfoReqDto extends RequestDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  承运商序列号，唯一索引
    */
    @ApiModelProperty(name = "carrierId", value = "承运商序列号，唯一索引")
    private String carrierId;
    /**
    *  CSP客户订单号
    */
    @ApiModelProperty(name = "cspNo", value = "CSP客户订单号")
    private String cspNo;
    /**
     *  PCP订单号
     */
    @ApiModelProperty(name = "pcpNo", value = "PCP订单号")
    private String pcpNo;
    /**
    *  EAS订单号
    */
    @ApiModelProperty(name = "easNo", value = "EAS订单号")
    private String easNo;
    /**
    *  承运商代码
    */
    @ApiModelProperty(name = "carrierCode", value = "承运商代码")
    private String carrierCode;
    /**
    *  承运商名称
    */
    @ApiModelProperty(name = "carrierName", value = "承运商名称")
    private String carrierName;
    /**
    *  承运商单号
    */
    @ApiModelProperty(name = "carrierNo", value = "承运商单号")
    private String carrierNo;
    /**
    *  托运单号
    */
    @ApiModelProperty(name = "consignmentNo", value = "托运单号")
    private String consignmentNo;
    /**
    *  状态 0:提交，1：捡货，2：发货，3：在途，4.签收
    */
    @ApiModelProperty(name = "status", value = "状态 0:提交，1：捡货，2：发货，3：在途，4.签收")
    private String status;
    /**
    *  
    */
    @ApiModelProperty(name = "orgName", value = "")
    private String orgName;
    /**
    *  捡货时间
    */
    @ApiModelProperty(name = "deliveStartTime", value = "捡货时间")
    private Date deliveStartTime;
    /**
    *  发货时间
    */
    @ApiModelProperty(name = "shipTime", value = "发货时间")
    private Date shipTime;
    /**
    *  预计到达时间
    */
    @ApiModelProperty(name = "expectedArrivalTime", value = "预计到达时间")
    private Date expectedArrivalTime;
    /**
    *  实际到达时间
    */
    @ApiModelProperty(name = "actualArrivalTime", value = "实际到达时间")
    private Date actualArrivalTime;
    /**
    *  货损数量
    */
    @ApiModelProperty(name = "cargoDamageNum", value = "货损数量")
    private Integer cargoDamageNum;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  操作时间
    */
    @ApiModelProperty(name = "operTime", value = "操作时间")
    private Date operTime;
    /**
    *  操作地点
    */
    @ApiModelProperty(name = "operAddr", value = "操作地点")
    private String operAddr;
    /**
    *  操作人
    */
    @ApiModelProperty(name = "operPerson", value = "操作人")
    private String operPerson;
    /**
    *  操作详情
    */
    @ApiModelProperty(name = "operInfo", value = "操作详情")
    private String operInfo;
    /**
    *  回单图片地址,如果有多张图，可以用逗号分隔
    */
    @ApiModelProperty(name = "pictureUrl", value = "回单图片地址,如果有多张图，可以用逗号分隔")
    private String pictureUrl;
    /**
    *  组织ID
    */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
    *  组织名称
    */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setCarrierId(String carrierId){
    this.carrierId = carrierId;
    }
    public String getCarrierId(){
    return this.carrierId;
    }
    public void setCspNo(String cspNo){
    this.cspNo = cspNo;
    }
    public String getCspNo(){
    return this.cspNo;
    }

    public String getPcpNo() {
        return pcpNo;
    }

    public void setPcpNo(String pcpNo) {
        this.pcpNo = pcpNo;
    }

    public void setEasNo(String easNo){
    this.easNo = easNo;
    }
    public String getEasNo(){
    return this.easNo;
    }
    public void setCarrierCode(String carrierCode){
    this.carrierCode = carrierCode;
    }
    public String getCarrierCode(){
    return this.carrierCode;
    }
    public void setCarrierName(String carrierName){
    this.carrierName = carrierName;
    }
    public String getCarrierName(){
    return this.carrierName;
    }
    public void setCarrierNo(String carrierNo){
    this.carrierNo = carrierNo;
    }
    public String getCarrierNo(){
    return this.carrierNo;
    }
    public void setConsignmentNo(String consignmentNo){
    this.consignmentNo = consignmentNo;
    }
    public String getConsignmentNo(){
    return this.consignmentNo;
    }
    public void setStatus(String status){
    this.status = status;
    }
    public String getStatus(){
    return this.status;
    }
    public void setOrgName(String orgName){
    this.orgName = orgName;
    }
    public String getOrgName(){
    return this.orgName;
    }
    public void setDeliveStartTime(Date deliveStartTime){
    this.deliveStartTime = deliveStartTime;
    }
    public Date getDeliveStartTime(){
    return this.deliveStartTime;
    }
    public void setShipTime(Date shipTime){
    this.shipTime = shipTime;
    }
    public Date getShipTime(){
    return this.shipTime;
    }
    public void setExpectedArrivalTime(Date expectedArrivalTime){
    this.expectedArrivalTime = expectedArrivalTime;
    }
    public Date getExpectedArrivalTime(){
    return this.expectedArrivalTime;
    }
    public void setActualArrivalTime(Date actualArrivalTime){
    this.actualArrivalTime = actualArrivalTime;
    }
    public Date getActualArrivalTime(){
    return this.actualArrivalTime;
    }
    public void setCargoDamageNum(Integer cargoDamageNum){
    this.cargoDamageNum = cargoDamageNum;
    }
    public Integer getCargoDamageNum(){
    return this.cargoDamageNum;
    }
    public void setRemark(String remark){
    this.remark = remark;
    }
    public String getRemark(){
    return this.remark;
    }
    public void setOperTime(Date operTime){
    this.operTime = operTime;
    }
    public Date getOperTime(){
    return this.operTime;
    }
    public void setOperAddr(String operAddr){
    this.operAddr = operAddr;
    }
    public String getOperAddr(){
    return this.operAddr;
    }
    public void setOperPerson(String operPerson){
    this.operPerson = operPerson;
    }
    public String getOperPerson(){
    return this.operPerson;
    }
    public void setOperInfo(String operInfo){
    this.operInfo = operInfo;
    }
    public String getOperInfo(){
    return this.operInfo;
    }
    public void setPictureUrl(String pictureUrl){
    this.pictureUrl = pictureUrl;
    }
    public String getPictureUrl(){
    return this.pictureUrl;
    }
    public void setOrganizationId(Long organizationId){
    this.organizationId = organizationId;
    }
    public Long getOrganizationId(){
    return this.organizationId;
    }
    public void setOrganizationName(String organizationName){
    this.organizationName = organizationName;
    }
    public String getOrganizationName(){
    return this.organizationName;
    }
}
