/**
 * @(#)CsActivityInventoryQueryDto.java 1.0 2022/01/17 10:06
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 其他出入库单查询Dto
 *
 * @author wuyue
 * @since 2022-04-25
 */
@ApiModel(value = "csOtherStorageOrderQueryDto", description = "其他出入库单查询Dto")
public class CsOtherStorageOrderQueryDto implements Serializable {

    /**
     * 其他出入库单
     */
    @ApiModelProperty(name = "otherStorageNo", value = "其他出入库单")
    private String otherStorageNo;

    /**
     * 业务类型
     */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private Long businessType;

    /**
     * 发货库存组织
     */
    @ApiModelProperty(name = "organization", value = "发货库存组织")
    private String organization;

    /**
     * 发货逻辑仓
     */
    @ApiModelProperty(name = "warehouseName", value = "发货逻辑仓")
    private String warehouseName;

    /**
     * 客户名称
     */
    @ApiModelProperty(name = "consignee", value = "客户名称")
    private String consignee;

    private List<Long> ids;

    private Long id;

    /**
     * 其他单据类型1:出库 2:入库
     */
    @ApiModelProperty(name = "type", value = "其他单据类型 other_out:出库 other_in:入库")
    private String type;

    /**
     * 来源类型 1:PCP 2:CSP
     */
    @ApiModelProperty(name = "orderSrc", value = "来源类型 PCP ,CSP")
    private String orderSrc;

    /**
     * 单据状态
     */
    @ApiModelProperty(name = "orderStatus", value = "单据状态")
    private String orderStatus;

    /**
     * 开始时间
     */
    @ApiModelProperty(name = "startTime", value = "开始时间 注意格式: 2022-04-27 11:59:59")
    private String startTime;

    /**
     * 结束时间
     */
    @ApiModelProperty(name = "endTime", value = "结束时间 格式 2022-04-27 11:59:59")
    private String endTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOtherStorageNo() {
        return otherStorageNo;
    }

    public void setOtherStorageNo(String otherStorageNo) {
        this.otherStorageNo = otherStorageNo;
    }

    public Long getBusinessType() {
        return businessType;
    }

    public void setBusinessType(Long businessType) {
        this.businessType = businessType;
    }

    public String getOrganization() {
        return organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getConsignee() {
        return consignee;
    }

    public void setConsignee(String consignee) {
        this.consignee = consignee;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getOrderSrc() {
        return orderSrc;
    }

    public void setOrderSrc(String orderSrc) {
        this.orderSrc = orderSrc;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }
}