/**
 * @(#)CsLogicInventoryAddReqDto.java 1.0 2021/12/29 11:11
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

//

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author jingran
 * @Description CsOutDeliveryReqDto
 * @Date: 2021/12/29 11:11
 * @since 1.0.0
 */
@ApiModel(value = "CsOutDeliveryDetailMessageDto", description = "消息通知DTO")
public class CsOutDeliveryDetailMessageDto implements Serializable {
    /**
     * 订单号
     **/
    @ApiModelProperty(name = "orderNo", value = "订单号")
    private String orderNo;

    /**
     * 商品长编码
     **/
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;

    /**
     * 批次
     **/
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;

    /**
     * 出库数量
     **/
    @ApiModelProperty(name = "outQuantity", value = "出库数量")
    private BigDecimal outQuantity;

    @ApiModelProperty(name = "tradeOrderItemId", value = "商品行明细id")
    private Long tradeOrderItemId;

    public Long getTradeOrderItemId() {
        return tradeOrderItemId;
    }

    public void setTradeOrderItemId(Long tradeOrderItemId) {
        this.tradeOrderItemId = tradeOrderItemId;
    }

    public CsOutDeliveryDetailMessageDto() {
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public BigDecimal getOutQuantity() {
        return outQuantity;
    }

    public void setOutQuantity(BigDecimal outQuantity) {
        this.outQuantity = outQuantity;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }
}