/**
 * @(#)CsLogicInventoryAddReqDto.java 1.0 2021/12/29 11:11
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

//

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author jingran
 * @Description CsOutDeliveryReqDto
 * @Date: 2021/12/29 11:11
 * @since 1.0.0
 */
@ApiModel(value = "CsOutDeliveryMessageDto", description = "消息通知DTO")
public class CsOutDeliveryMessageDto implements Serializable {
    /**
     * 订单号
     **/
    @ApiModelProperty(name = "orderNo", value = "订单号")
    private String orderNo;
    /**
     * 总数量
     **/
    @ApiModelProperty(name = "totalQuantity", value = "总数量")
    private BigDecimal totalQuantity;
    /**
     * 拼箱数
     **/
    @ApiModelProperty(name = "mergeQuantity", value = "拼箱数")
    private BigDecimal mergeQuantity;
    /**
     * 总箱数
     **/
    @ApiModelProperty(name = "totalCartons", value = "总箱数")
    private BigDecimal totalCartons;
    /**
     * 出库明细信息
     **/
    @ApiModelProperty(name = "deliveryDetailMessageDtoList", value = "出库明细信息")
    private List<CsOutDeliveryDetailMessageDto> deliveryDetailMessageDtoList;

    public CsOutDeliveryMessageDto() {
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public BigDecimal getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public BigDecimal getMergeQuantity() {
        return mergeQuantity;
    }

    public void setMergeQuantity(BigDecimal mergeQuantity) {
        this.mergeQuantity = mergeQuantity;
    }

    public List<CsOutDeliveryDetailMessageDto> getDeliveryDetailMessageDtoList() {
        return deliveryDetailMessageDtoList;
    }

    public void setDeliveryDetailMessageDtoList(List<CsOutDeliveryDetailMessageDto> deliveryDetailMessageDtoList) {
        this.deliveryDetailMessageDtoList = deliveryDetailMessageDtoList;
    }

    public BigDecimal getTotalCartons() {
        return totalCartons;
    }

    public void setTotalCartons(BigDecimal totalCartons) {
        this.totalCartons = totalCartons;
    }
}