/**
 * @(#)CsLogicInventoryAddReqDto.java 1.0 2021/12/29 11:11
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

//
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
* @Description CsOutDeliveryReqDto
*
* @author jingran
* @Date: 2021/12/29 11:11
* @since 1.0.0
*/
@ApiModel(value = "CsOutDeliveryReqDto", description = "新增Dto")
public class CsOutDeliveryReqDto implements Serializable {

    /** 订单号 **/
    @ApiModelProperty(name="orderNo",value = "订单号")
    private String orderNo;

    /** 物流公司编码，SF=顺丰、EMS=标准快递、EYB=经济快件、ZJS=宅急送、YTO=圆通、ZTO=中通 (ZTO)、HTKY=百世汇通、BSKY=百世快运、BSKY=百世快运、UC=优速、STO=申通、TTKDEX=天天快递、QFKD=全峰、FAST=快捷、POSTB=邮政小包、GTO=国通、YUNDA=韵达、JD=京东配送、DD=当当宅配、AMAZON=亚马逊物流、DBWL=德邦物流、DBKD=德邦快递、DBKY=德邦快运、RRS=日日顺、OTHER=其他，(只传英文编码) **/
    @ApiModelProperty(name="shippingCompanyCode",value = "物流公司编码，SF=顺丰、EMS=标准快递、EYB=经济快件、ZJS=宅急送、YTO=圆通、ZTO=中通 (ZTO)、HTKY=百世汇通、BSKY=百世快运、BSKY=百世快运、UC=优速、STO=申通、TTKDEX=天天快递、QFKD=全峰、FAST=快捷、POSTB=邮政小包、GTO=国通、YUNDA=韵达、JD=京东配送、DD=当当宅配、AMAZON=亚马逊物流、DBWL=德邦物流、DBKD=德邦快递、DBKY=德邦快运、RRS=日日顺、OTHER=其他，(只传英文编码)")
    private String shippingCompanyCode;

    /** 物流公司运单号（存储母单号） **/
    @ApiModelProperty(name="shippingCode",value = "物流公司运单号（存储母单号）")
    private String shippingCode;

    /**
     * 物流公司名称
     */
    @ApiModelProperty(name = "shippingCompany", value = "物流公司名称")
    private String shippingCompany;

    /** 总数量 **/
    @ApiModelProperty(name="totalQuantity",value = "总箱数")
    private BigDecimal totalQuantity;

    /** 拼箱数 **/
    @ApiModelProperty(name="mergeQuantity",value = "拼箱数")
    private BigDecimal mergeQuantity;

    public CsOutDeliveryReqDto() {
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getShippingCode() {
        return shippingCode;
    }

    public void setShippingCode(String shippingCode) {
        this.shippingCode = shippingCode;
    }

    public BigDecimal getMergeQuantity() {
        return mergeQuantity;
    }

    public void setMergeQuantity(BigDecimal mergeQuantity) {
        this.mergeQuantity = mergeQuantity;
    }

    public String getShippingCompanyCode() {
        return shippingCompanyCode;
    }

    public void setShippingCompanyCode(String shippingCompanyCode) {
        this.shippingCompanyCode = shippingCompanyCode;
    }

    public String getShippingCompany() {
        return shippingCompany;
    }

    public void setShippingCompany(String shippingCompany) {
        this.shippingCompany = shippingCompany;
    }

    public BigDecimal getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
    }
}