package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
* 质检转合格查询对象
*
* @author 宁毅
* @since 2022-05-26
*/
@ApiModel(value = "CsQualityInfoDetailReqDto", description = "质检转合格查询对象")
public class CsQualityInfoDetailQueryDto implements Serializable {
    /**
    *  计划单号
    */
    @ApiModelProperty(name = "plannedOrderNo", value = "计划单号")
    private String plannedOrderNo;
    /**
    *  商品长编码
    */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;

    /**
     *  商品名称
     */
    @ApiModelProperty(name = "cargoName", value = "商品名称")
    private String cargoName;
    /**
     *  开始时间
     */
    @ApiModelProperty(name = "beginTime", value = "开始时间")
    private String beginTime;
    /**
     *  结束时间
     */
    @ApiModelProperty(name = "endTime", value = "结束时间")
    private String endTime;
    /**
    *  推送WMS状态,success-成功,failure-失败
    */
    @ApiModelProperty(name = "pushWmsStatus", value = "推送WMS状态,success-成功,failure-失败")
    private String pushWmsStatus;

    /**
     *  放行状态：unPassed-是(待放行),passed-否(已放行)
     */
    @ApiModelProperty(name = "dischargedStatus", value = "放行状态：unPassed-是(待放行),passed-否(已放行)")
    private String dischargedStatus;

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;

    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;

    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照create_time降序")
    private String orderByDesc = "create_time";

    /**
     *  备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;


    public String getPlannedOrderNo() {
        return plannedOrderNo;
    }

    public void setPlannedOrderNo(String plannedOrderNo) {
        this.plannedOrderNo = plannedOrderNo;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getPushWmsStatus() {
        return pushWmsStatus;
    }

    public void setPushWmsStatus(String pushWmsStatus) {
        this.pushWmsStatus = pushWmsStatus;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }

    public String getDischargedStatus() {
        return dischargedStatus;
    }

    public void setDischargedStatus(String dischargedStatus) {
        this.dischargedStatus = dischargedStatus;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
