package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
* LIMS质检数据同步表Eo对象
*
* @author 宁毅
* @since 2022-05-26
*/
@ApiModel(value = "CsQualityInfoReqDto", description = "LIMS质检数据同步表Eo对象")
public class CsQualityInfoReqDto extends RequestDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  委托ID，唯一编号。由外部系统传入
    */
    @ApiModelProperty(name = "externalId", value = "委托ID，唯一编号。由外部系统传入")
    private String externalId;
    /**
    *  委托单号
    */
    @ApiModelProperty(name = "externalNo", value = "委托单号")
    private String externalNo;
    /**
    *  委托来源（EAS MES OA）
    */
    @ApiModelProperty(name = "sourceFrom", value = "委托来源（EAS MES OA）")
    private String sourceFrom;
    /**
    *  QA补充信息
    */
    @ApiModelProperty(name = "externalRemark", value = "QA补充信息")
    private String externalRemark;
    /**
    *  商品长编码
    */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    /**
    *  货品编码
    */
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  商品合格数量
    */
    @ApiModelProperty(name = "qualifiedNum", value = "商品合格数量")
    private BigDecimal qualifiedNum;
    /**
    *  商品不合格数量
    */
    @ApiModelProperty(name = "unqualifiedNum", value = "商品不合格数量")
    private BigDecimal unqualifiedNum;
    /**
    *  商品放行数量
    */
    @ApiModelProperty(name = "releaseNum", value = "商品放行数量")
    private BigDecimal releaseNum;
    /**
    *  报告建立时间
    */
    @ApiModelProperty(name = "reportTime", value = "报告建立时间")
    private Date reportTime;
    /**
    *  质检报告,qualified-合格,disqualification-不合格
    */
    @ApiModelProperty(name = "reportResult", value = "质检报告,qualified-合格,disqualification-不合格")
    private String reportResult;
    /**
    *  检测报告URL
    */
    @ApiModelProperty(name = "reportResultUrl", value = "检测报告URL")
    private String reportResultUrl;
    /**
    *  WMS状态
    */
    @ApiModelProperty(name = "wmsStatus", value = "WMS状态")
    private String wmsStatus;
    /**
    *  采样类型
    */
    @ApiModelProperty(name = "sampleType", value = "采样类型")
    private String sampleType;
    /**
    *  系统类型
    */
    @ApiModelProperty(name = "systemType", value = "系统类型")
    private String systemType;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    @ApiModelProperty(name="sourceSystem",value = "来源系统")
    private String sourceSystem;

    public String getSourceSystem() {
        return sourceSystem;
    }

    public void setSourceSystem(String sourceSystem) {
        this.sourceSystem = sourceSystem;
    }
    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setExternalId(String externalId){
    this.externalId = externalId;
    }
    public String getExternalId(){
    return this.externalId;
    }
    public void setExternalNo(String externalNo){
    this.externalNo = externalNo;
    }
    public String getExternalNo(){
    return this.externalNo;
    }
    public void setSourceFrom(String sourceFrom){
    this.sourceFrom = sourceFrom;
    }
    public String getSourceFrom(){
    return this.sourceFrom;
    }
    public void setExternalRemark(String externalRemark){
    this.externalRemark = externalRemark;
    }
    public String getExternalRemark(){
    return this.externalRemark;
    }
    public void setLongCode(String longCode){
    this.longCode = longCode;
    }
    public String getLongCode(){
    return this.longCode;
    }
    public void setCargoCode(String cargoCode){
    this.cargoCode = cargoCode;
    }
    public String getCargoCode(){
    return this.cargoCode;
    }
    public void setBatch(String batch){
    this.batch = batch;
    }
    public String getBatch(){
    return this.batch;
    }
    public void setQualifiedNum(BigDecimal qualifiedNum){
    this.qualifiedNum = qualifiedNum;
    }
    public BigDecimal getQualifiedNum(){
    return this.qualifiedNum;
    }
    public void setUnqualifiedNum(BigDecimal unqualifiedNum){
    this.unqualifiedNum = unqualifiedNum;
    }
    public BigDecimal getUnqualifiedNum(){
    return this.unqualifiedNum;
    }
    public void setReleaseNum(BigDecimal releaseNum){
    this.releaseNum = releaseNum;
    }
    public BigDecimal getReleaseNum(){
    return this.releaseNum;
    }
    public void setReportTime(Date reportTime){
    this.reportTime = reportTime;
    }
    public Date getReportTime(){
    return this.reportTime;
    }
    public void setReportResult(String reportResult){
    this.reportResult = reportResult;
    }
    public String getReportResult(){
    return this.reportResult;
    }
    public void setReportResultUrl(String reportResultUrl){
    this.reportResultUrl = reportResultUrl;
    }
    public String getReportResultUrl(){
    return this.reportResultUrl;
    }
    public void setWmsStatus(String wmsStatus){
    this.wmsStatus = wmsStatus;
    }
    public String getWmsStatus(){
    return this.wmsStatus;
    }
    public void setSampleType(String sampleType){
    this.sampleType = sampleType;
    }
    public String getSampleType(){
    return this.sampleType;
    }
    public void setSystemType(String systemType){
    this.systemType = systemType;
    }
    public String getSystemType(){
    return this.systemType;
    }
    public void setRemark(String remark){
    this.remark = remark;
    }
    public String getRemark(){
    return this.remark;
    }
}
