package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 实时库存查询请求参数
 */
@Data
public class CsRealTimeInventoryQueryDto implements Serializable {
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    @ApiModelProperty(name = "cargoName", value = "商品名称")
    private String cargoName;
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    @ApiModelProperty(name = "expired", value = "是否过期 0否 1是")
    private Integer expired;
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    @ApiModelProperty(name = "gtBalance", value = "库存大于0 0否 1是")
    private String gtBalance;
    @ApiModelProperty(name = "warehouseClassify", value = "仓库类型")
    private List<String> warehouseClassify;

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;
    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;
}
