/**
 * @(#)CsLogicInventoryAddReqDto.java 1.0 2021/12/29 11:11
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

//
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 *
 * 销售退WMS回传发MQ
 *
* @Description CsOutDeliveryReqDto
*
* @author jingran
* @Date: 2021/12/29 11:11
* @since 1.0.0
*/
@ApiModel(value = "CsSaleRefundInDeliveryMessageDto", description = "销售退WMS回传发MQ")
public class CsSaleRefundInDeliveryMessageDto implements Serializable {

    /** 订单号 **/
    @ApiModelProperty(name="orderNo",value = "订单号")
    private String orderNo;

    /** 当前销售退已入库的总数量 **/
    @ApiModelProperty(name="totalQuantity",value = "当前销售退已入库的总数量")
    private BigDecimal totalQuantity;

    /** 类型标识  SEND_BACK:WMS发货回传   SEND_CANCEL:WMS发起取消     **/
    @ApiModelProperty(name="typeFlag",value = "类型标识  SEND_BACK:WMS发货回传   SEND_CANCEL:WMS发起取消 ")
    private String typeFlag;

    /** 变更状态 **/
    @ApiModelProperty(name="status",value = "变更状态")
    private String status;

    public CsSaleRefundInDeliveryMessageDto() {
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public BigDecimal getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public String getTypeFlag() {
        return typeFlag;
    }

    public void setTypeFlag(String typeFlag) {
        this.typeFlag = typeFlag;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}