package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 库存盘点单导入商品解析dto
 *
 * @author 宁毅
 * @since 2022-04-25
 */
@ApiModel(value = "CsTakeStockImportItemDto", description = "库存盘点单导入商品解析dto")
public class CsTakeStockImportItemDto implements Serializable {
    /**
     * 商品长编码
     */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    @Excel(name = "商品长编码")
    private String longCode;

    /**
     * 批次号
     */
    @ApiModelProperty(name = "batch", value = "批次号")
    @Excel(name = "批次号")
    private String batch;

    /**
     * 实盘数量
     */
    @ApiModelProperty(name = "firmOfferNum", value = "实盘数量")
    @Excel(name = "实盘数量")
    private Integer firmOfferNum;

    /**
     * 错误信息
     */
    @ApiModelProperty(name = "errorInfo", value = "错误信息")
    @Excel(name = "错误信息")
    private String errorInfo;

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public Integer getFirmOfferNum() {
        return firmOfferNum;
    }

    public void setFirmOfferNum(Integer firmOfferNum) {
        this.firmOfferNum = firmOfferNum;
    }

    public String getErrorInfo() {
        return errorInfo;
    }

    public void setErrorInfo(String errorInfo) {
        this.errorInfo = errorInfo;
    }
}
