package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 调拨单单查询Dto
 *
 * @author wuyue
 * @since 2022-04-25
 */
@ApiModel(value = "CsTransferOrderQueryDto", description = "调拨单单查询Dto")
public class CsTransferOrderQueryDto implements Serializable {

    /**
     * 其他出入库单
     */
    @ApiModelProperty(name = "transferOrderNo", value = "调拨单号")
    private String transferOrderNo;

    @ApiModelProperty(name="transferOrderNoList", value = "调拨单号列表")
    private List<String> transferOrderNoList;

    /**
     * 父级单号（拆单场景使用）
     */
    @ApiModelProperty(name = "parentOrderNo", value = "调拨单号")
    private String parentOrderNo;


    @ApiModelProperty(name = "parentOrderNo", value = "前置单号")
    private List<String> preOrderNoList;

    /**
     * 单据状态
     */
    @ApiModelProperty(name = "orderStatus", value = "单据状态")
    private String orderStatus;

    /**
     * 单据状态集合入参
     */
    @ApiModelProperty(name = "orderStatusList", value = "单据状态集合入参")
    private List<String> orderStatusList;

    /**
     * 调拨类型
     */
    @ApiModelProperty(name = "type", value = "调拨类型")
    private String type;

    @ApiModelProperty(name = "typeList", value = "调拨类型集合")
    private List<String> typeList;

    /**
     * 开始时间
     */
    @ApiModelProperty(name = "startTime", value = "开始时间 注意格式: 2022-04-27 11:59:59")
    private String startTime;

    /**
     * 结束时间
     */
    @ApiModelProperty(name = "endTime", value = "结束时间 格式 2022-04-27 11:59:59")
    private String endTime;

    /**
     * 调出逻辑仓编码
     */
    @ApiModelProperty(name = "outLogicWarehouseCode", value = "调出逻辑仓编码")
    private String outLogicWarehouseCode;
    /**
     * 调出逻辑仓名称
     */
    @ApiModelProperty(name = "outLogicWarehouseName", value = "调出逻辑仓名称")
    private String outLogicWarehouseName;

    /**
     * 调入货逻辑仓编码
     */
    @ApiModelProperty(name = "inLogicWarehouseName", value = "调入货逻辑仓编码")
    private String inLogicWarehouseCode;
    /**
     * 调入逻辑仓名称
     */
    @ApiModelProperty(name = "inLogicWarehouseName", value = "调入逻辑仓名称")
    private String inLogicWarehouseName;

    @ApiModelProperty(name = "outPhysicsWarehouseCodeList", value = "调出物理仓编码集合")
    private List<String> outPhysicsWarehouseCodeList;

    public List<String> getPreOrderNoList() {
        return preOrderNoList;
    }

    public void setPreOrderNoList(List<String> preOrderNoList) {
        this.preOrderNoList = preOrderNoList;
    }

    public List<String> getTypeList() {
        return typeList;
    }

    public void setTypeList(List<String> typeList) {
        this.typeList = typeList;
    }


    public List<String> getTransferOrderNoList() {
        return transferOrderNoList;
    }

    public void setTransferOrderNoList(List<String> transferOrderNoList) {
        this.transferOrderNoList = transferOrderNoList;
    }


    public String getParentOrderNo() {
        return parentOrderNo;
    }

    public void setParentOrderNo(String parentOrderNo) {
        this.parentOrderNo = parentOrderNo;
    }

    public String getTransferOrderNo() {
        return transferOrderNo;
    }

    public void setTransferOrderNo(String transferOrderNo) {
        this.transferOrderNo = transferOrderNo;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getOutLogicWarehouseCode() {
        return outLogicWarehouseCode;
    }

    public void setOutLogicWarehouseCode(String outLogicWarehouseCode) {
        this.outLogicWarehouseCode = outLogicWarehouseCode;
    }

    public String getOutLogicWarehouseName() {
        return outLogicWarehouseName;
    }

    public void setOutLogicWarehouseName(String outLogicWarehouseName) {
        this.outLogicWarehouseName = outLogicWarehouseName;
    }

    public String getInLogicWarehouseCode() {
        return inLogicWarehouseCode;
    }

    public void setInLogicWarehouseCode(String inLogicWarehouseCode) {
        this.inLogicWarehouseCode = inLogicWarehouseCode;
    }

    public String getInLogicWarehouseName() {
        return inLogicWarehouseName;
    }

    public void setInLogicWarehouseName(String inLogicWarehouseName) {
        this.inLogicWarehouseName = inLogicWarehouseName;
    }

    public List<String> getOutPhysicsWarehouseCodeList() {
        return outPhysicsWarehouseCodeList;
    }

    public void setOutPhysicsWarehouseCodeList(List<String> outPhysicsWarehouseCodeList) {
        this.outPhysicsWarehouseCodeList = outPhysicsWarehouseCodeList;
    }

    public List<String> getOrderStatusList() {
        return orderStatusList;
    }

    public void setOrderStatusList(List<String> orderStatusList) {
        this.orderStatusList = orderStatusList;
    }
}