/**
 * @(#) SubmitOtherOutBody.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * SubmitOtherOutBody
 */
@Getter
@Setter
@ApiModel(value = "OtherStorageAuditBatchReqDto", description = "")
public class OtherStorageAuditBatchReqDto {

    @ApiModelProperty(name = "auditResult", value = "审核结果")
    @JsonProperty("auditResult")
    @NotBlank(message = "审批结果不能为空")
    private String auditResult = null;


    @ApiModelProperty(name = "auditReason", value = "审核原因")
    @JsonProperty("auditReason")
    private String auditReason = null;


    @ApiModelProperty(name = "isOaAudit", value = "是否OA审核")
    private String isOaAudit = null;

    @ApiModelProperty(name = "auditIds", value = "审核ids")
    //@NotEmpty(message = "审批通过的记录id不能为空")
    private List<Long> auditIds;

    @ApiModelProperty(name = "auditId", value = "审核id")
//    @NotEmpty(message = "审批通过的记录id不能为空")
    private Long auditId;
}

