/**
 * @(#)CsItemAddReqDto.java 1.0 2022/03/10 11:51
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.item;

import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.BaseRequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
* @Description CsItemAddReqDto
*
* @author chujian
* @Date: 2022/03/10 11:51
* @since 1.0.0
*/
@ApiModel(value = "csItemAddReqDto", description = "新增Dto")
public class CsItemAddReqDto implements Serializable {

    /** 分组ID */
    @ApiModelProperty(name="groupId",value = "分组ID")
    private Long groupId;
    /** 商品长编码 */
    @ApiModelProperty(name="longCode",value = "商品长编码")
    private String longCode;
    /** 编码 */
    @ApiModelProperty(name="code",value = "编码")
    private String code;
    /** 商品货号 */
    @ApiModelProperty(name="artNo",value = "商品货号")
    private String artNo;
    /** 商品条码 */
    @ApiModelProperty(name="barCode",value = "商品条码")
    private String barCode;
    /** 是否串码管理 */
    @ApiModelProperty(name="imeiCodeFlag",value = "是否串码管理")
    private String imeiCodeFlag;
    /** 1-有效 0-无效 */
    @ApiModelProperty(name="itemStatus",value = "1-有效 0-无效")
    private Long itemStatus;
    /** 商品剂型 1-粉剂 */
    @ApiModelProperty(name="itemDrug",value = "商品剂型 1-粉剂")
    private Long itemDrug;
    /** 标准批文 */
    @ApiModelProperty(name="standardApproval",value = "标准批文")
    private String standardApproval;
    /** 旧批文 */
    @ApiModelProperty(name="oldApproval",value = "旧批文")
    private String oldApproval;
    /** 规格 */
    @ApiModelProperty(name="specification",value = "规格")
    private String specification;
    /** 1-产品 2-赠品 3-促销物料 */
    @ApiModelProperty(name="itemType",value = "1-产品 2-赠品 3-促销物料")
    private Long itemType;
    /** 名称 */
    @ApiModelProperty(name="name",value = "名称")
    private String name;
    /** 单位 */
    @ApiModelProperty(name="unit",value = "单位")
    private String unit;
    /** NC单位ID */
    @ApiModelProperty(name="unitId",value = "NC单位ID")
    private Long unitId;
    /** 建议零售价 */
    @ApiModelProperty(name="recommendPrice",value = "建议零售价")
    private BigDecimal recommendPrice;
    /** 品牌编码 */
    @ApiModelProperty(name="brandCode",value = "品牌编码")
    private String brandCode;
    /** 品牌名称 */
    @ApiModelProperty(name="brandName",value = "品牌名称")
    private String brandName;
    /** 产地 */
    @ApiModelProperty(name="placeOfOrigin",value = "产地")
    private String placeOfOrigin;
    /** 线下安全库存 */
    @ApiModelProperty(name="offlineSafetyStock",value = "线下安全库存")
    private BigDecimal offlineSafetyStock;
    /** 安全库存策略，0-关闭，1-开启 */
    @ApiModelProperty(name="safetyStockStrategy",value = "安全库存策略，0-关闭，1-开启")
    private Integer safetyStockStrategy;
    /** 是否线下可售，0-否，1-是 */
    @ApiModelProperty(name="ifAvailableOffline",value = "是否线下可售，0-否，1-是")
    private Integer ifAvailableOffline;
    /** 防超卖库存数 */
    @ApiModelProperty(name="avoidOversoldInventory",value = "防超卖库存数")
    private BigDecimal avoidOversoldInventory;
    /** 单渠道共享数 */
    @ApiModelProperty(name="singleChannelShare",value = "单渠道共享数")
    private BigDecimal singleChannelShare;
    /** 单渠道共享指定店铺 */
    @ApiModelProperty(name="singleChannelShopId",value = "单渠道共享指定店铺")
    private Long singleChannelShopId;
    /** 库存检查配置 */
    @ApiModelProperty(name="checkConfigId",value = "库存检查配置")
    private Long checkConfigId;
    /** 珠海仓托盘数量 */
    @ApiModelProperty(name="zhTrayNum",value = "珠海仓托盘数量")
    private Long zhTrayNum;
    /** 拆包配置 */
    @ApiModelProperty(name="packageSplitId",value = "拆包配置")
    private Long packageSplitId;
    /** 重量 */
    @ApiModelProperty(name="quantity",value = "重量")
    private BigDecimal quantity;
    /** 大包系数 */
    @ApiModelProperty(name="bigRatio",value = "大包系数")
    private Long bigRatio;
    /** 中包系数 */
    @ApiModelProperty(name="middleRatio",value = "中包系数")
    private Long middleRatio;
    /** 小包系数 */
    @ApiModelProperty(name="smallRatio",value = "小包系数")
    private Long smallRatio;
    /** 防伪码 */
    @ApiModelProperty(name="securityCode",value = "防伪码")
    private String securityCode;
    /** 保质期单位 */
    @ApiModelProperty(name="expirationUnit",value = "保质期单位")
    private String expirationUnit;
    /** 保质期 */
    @ApiModelProperty(name="expirationDate",value = "保质期")
    private String expirationDate;
    /** 是否免检 */
    @ApiModelProperty(name="exemption",value = "是否免检")
    private String exemption;
    /** 体积 */
    @ApiModelProperty(name="volume",value = "体积")
    private BigDecimal volume;
    /** 长 */
    @ApiModelProperty(name="length",value = "长")
    private BigDecimal length;
    /** 宽 */
    @ApiModelProperty(name="width",value = "宽")
    private BigDecimal width;
    /** 高 */
    @ApiModelProperty(name="height",value = "高")
    private BigDecimal height;
    /** 长单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm */
    @ApiModelProperty(name="lengthUnit",value = "长单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String lengthUnit;
    /** 高单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm */
    @ApiModelProperty(name="heightUnit",value = "高单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String heightUnit;
    /** 宽单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm */
    @ApiModelProperty(name="widthUnit",value = "宽单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String widthUnit;
    /** 重量单位 */
    @ApiModelProperty(name="quantityUnit",value = "重量单位")
    private String quantityUnit;
    /** 所属客户编码 */
    @ApiModelProperty(name="customerNo",value = "所属客户编码")
    private String customerNo;
    /** 货品详情 */
    @ApiModelProperty(name="detail",value = "货品详情")
    private String detail;
    /** 运费模板(面向运营) */
    @ApiModelProperty(name="shippingTplId",value = "运费模板(面向运营)")
    private Long shippingTplId;
    /** 增值税率 */
    @ApiModelProperty(name="taxRate",value = "增值税率")
    private Integer taxRate;
    /** 毛重 */
    @ApiModelProperty(name="grossWeight",value = "毛重")
    private BigDecimal grossWeight;
    /** 毛重单位 */
    @ApiModelProperty(name="grossWeightUnit",value = "毛重单位")
    private String grossWeightUnit;
    /** 净重 */
    @ApiModelProperty(name="netWeight",value = "净重")
    private BigDecimal netWeight;
    /** 净重单位 */
    @ApiModelProperty(name="netWeightUnit",value = "净重单位")
    private String netWeightUnit;

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public String getBarCode() {
        return barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public String getImeiCodeFlag() {
        return imeiCodeFlag;
    }

    public void setImeiCodeFlag(String imeiCodeFlag) {
        this.imeiCodeFlag = imeiCodeFlag;
    }

    public Long getItemStatus() {
        return itemStatus;
    }

    public void setItemStatus(Long itemStatus) {
        this.itemStatus = itemStatus;
    }

    public Long getItemDrug() {
        return itemDrug;
    }

    public void setItemDrug(Long itemDrug) {
        this.itemDrug = itemDrug;
    }

    public String getStandardApproval() {
        return standardApproval;
    }

    public void setStandardApproval(String standardApproval) {
        this.standardApproval = standardApproval;
    }

    public String getOldApproval() {
        return oldApproval;
    }

    public void setOldApproval(String oldApproval) {
        this.oldApproval = oldApproval;
    }

    public Long getItemType() {
        return itemType;
    }

    public void setItemType(Long itemType) {
        this.itemType = itemType;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public BigDecimal getRecommendPrice() {
        return recommendPrice;
    }

    public void setRecommendPrice(BigDecimal recommendPrice) {
        this.recommendPrice = recommendPrice;
    }

    public String getBrandCode() {
        return brandCode;
    }

    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getPlaceOfOrigin() {
        return placeOfOrigin;
    }

    public void setPlaceOfOrigin(String placeOfOrigin) {
        this.placeOfOrigin = placeOfOrigin;
    }

    public BigDecimal getOfflineSafetyStock() {
        return offlineSafetyStock;
    }

    public void setOfflineSafetyStock(BigDecimal offlineSafetyStock) {
        this.offlineSafetyStock = offlineSafetyStock;
    }

    public Integer getSafetyStockStrategy() {
        return safetyStockStrategy;
    }

    public void setSafetyStockStrategy(Integer safetyStockStrategy) {
        this.safetyStockStrategy = safetyStockStrategy;
    }

    public Integer getIfAvailableOffline() {
        return ifAvailableOffline;
    }

    public void setIfAvailableOffline(Integer ifAvailableOffline) {
        this.ifAvailableOffline = ifAvailableOffline;
    }

    public BigDecimal getAvoidOversoldInventory() {
        return avoidOversoldInventory;
    }

    public void setAvoidOversoldInventory(BigDecimal avoidOversoldInventory) {
        this.avoidOversoldInventory = avoidOversoldInventory;
    }

    public BigDecimal getSingleChannelShare() {
        return singleChannelShare;
    }

    public void setSingleChannelShare(BigDecimal singleChannelShare) {
        this.singleChannelShare = singleChannelShare;
    }

    public Long getSingleChannelShopId() {
        return singleChannelShopId;
    }

    public void setSingleChannelShopId(Long singleChannelShopId) {
        this.singleChannelShopId = singleChannelShopId;
    }

    public Long getCheckConfigId() {
        return checkConfigId;
    }

    public void setCheckConfigId(Long checkConfigId) {
        this.checkConfigId = checkConfigId;
    }

    public Long getZhTrayNum() {
        return zhTrayNum;
    }

    public void setZhTrayNum(Long zhTrayNum) {
        this.zhTrayNum = zhTrayNum;
    }

    public Long getPackageSplitId() {
        return packageSplitId;
    }

    public void setPackageSplitId(Long packageSplitId) {
        this.packageSplitId = packageSplitId;
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public Long getBigRatio() {
        return bigRatio;
    }

    public void setBigRatio(Long bigRatio) {
        this.bigRatio = bigRatio;
    }

    public Long getMiddleRatio() {
        return middleRatio;
    }

    public void setMiddleRatio(Long middleRatio) {
        this.middleRatio = middleRatio;
    }

    public Long getSmallRatio() {
        return smallRatio;
    }

    public void setSmallRatio(Long smallRatio) {
        this.smallRatio = smallRatio;
    }

    public String getSecurityCode() {
        return securityCode;
    }

    public void setSecurityCode(String securityCode) {
        this.securityCode = securityCode;
    }

    public String getExpirationUnit() {
        return expirationUnit;
    }

    public void setExpirationUnit(String expirationUnit) {
        this.expirationUnit = expirationUnit;
    }

    public String getExpirationDate() {
        return expirationDate;
    }

    public void setExpirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getExemption() {
        return exemption;
    }

    public void setExemption(String exemption) {
        this.exemption = exemption;
    }

    public BigDecimal getVolume() {
        return volume;
    }

    public void setVolume(BigDecimal volume) {
        this.volume = volume;
    }

    public BigDecimal getLength() {
        return length;
    }

    public void setLength(BigDecimal length) {
        this.length = length;
    }

    public BigDecimal getWidth() {
        return width;
    }

    public void setWidth(BigDecimal width) {
        this.width = width;
    }

    public BigDecimal getHeight() {
        return height;
    }

    public void setHeight(BigDecimal height) {
        this.height = height;
    }

    public String getLengthUnit() {
        return lengthUnit;
    }

    public void setLengthUnit(String lengthUnit) {
        this.lengthUnit = lengthUnit;
    }

    public String getHeightUnit() {
        return heightUnit;
    }

    public void setHeightUnit(String heightUnit) {
        this.heightUnit = heightUnit;
    }

    public String getWidthUnit() {
        return widthUnit;
    }

    public void setWidthUnit(String widthUnit) {
        this.widthUnit = widthUnit;
    }

    public String getQuantityUnit() {
        return quantityUnit;
    }

    public void setQuantityUnit(String quantityUnit) {
        this.quantityUnit = quantityUnit;
    }

    public String getCustomerNo() {
        return customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }

    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public Long getShippingTplId() {
        return shippingTplId;
    }

    public void setShippingTplId(Long shippingTplId) {
        this.shippingTplId = shippingTplId;
    }

    public Integer getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(Integer taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getGrossWeight() {
        return grossWeight;
    }

    public void setGrossWeight(BigDecimal grossWeight) {
        this.grossWeight = grossWeight;
    }

    public String getGrossWeightUnit() {
        return grossWeightUnit;
    }

    public void setGrossWeightUnit(String grossWeightUnit) {
        this.grossWeightUnit = grossWeightUnit;
    }

    public BigDecimal getNetWeight() {
        return netWeight;
    }

    public void setNetWeight(BigDecimal netWeight) {
        this.netWeight = netWeight;
    }

    public String getNetWeightUnit() {
        return netWeightUnit;
    }

    public void setNetWeightUnit(String netWeightUnit) {
        this.netWeightUnit = netWeightUnit;
    }

    public String getSpecification() {
        return specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }
}