/**
 * @(#)CsBatchAdjustmentOrderAuditReqDto.java 1.0 2022/05/11 15:46
 * <p>
 * Copyright (c) 2022, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 **/
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @author wenyi
 * @Description CsBatchAdjustmentOrderAuditReqDto
 * @Date: 2022/05/11 15:46
 * @since 1.0.0
 **/
@ApiModel(value = "CsBatchAdjustmentOrderAuditReqDto", description = "批次调整单审核DTO")
public class CsBatchAdjustmentOrderAuditReqDto implements Serializable {
    /**
     * 单据单号
     **/
    @ApiModelProperty(name = "orderNo", value = "单据单号")
    private String orderNo;

    /**
     * 备注信息
     **/
    @ApiModelProperty(name = "remark", value = "备注信息")
    private String remark;

    /**
     * 审核结果:audit_pass-审核通过,audit_failed-审核不通过
     **/
    @ApiModelProperty(name = "auditResult", value = "审核结果:audit_pass-审核通过,audit_failed-审核不通过")
    private String auditResult;


    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getAuditResult() {
        return auditResult;
    }

    public void setAuditResult(String auditResult) {
        this.auditResult = auditResult;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }
}