/**
 * @(#)CsBatchAdjustmentOrderPageQueryDto.java 1.0 2022/04/19 17:21
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
* @Description CsBatchAdjustmentOrderPageQueryDto
*
* @author jingran
* @Date: 2022/04/19 17:21
* @since 1.0.0
*/
@ApiModel(value = "CsBatchAdjustmentOrderPageQueryDto", description = "批次调整单分页查询Dto")
public class CsBatchAdjustmentOrderPageQueryDto extends BaseRespDto {

    /** 批次调整单号 */
    @ApiModelProperty(name="orderNo",value = "批次调整单号")
    private String orderNo;
    /** 业务类型：general_adjustment:普通调整 */
    @ApiModelProperty(name="businessType",value = "业务类型：general_adjustment:普通调整")
    private String businessType;
    /** 单据状态：wait_submit：待提交、wait_audit：待审核、completed：已完成、cancel：已取消、audit_failed：审核不通过 */
    @ApiModelProperty(name="orderStatus",value = "单据状态：wait_submit：待提交、wait_audit：待审核、completed：已完成、cancel：已取消、audit_failed：审核不通过")
    private String orderStatus;
    /** 是否同步wms：1是，0否 */
    @ApiModelProperty(name="synchronousWms",value = "是否同步wms：1是，0否")
    private Integer synchronousWms;
    /** 逻辑仓库ID */
    @ApiModelProperty(name="warehouseId",value = "逻辑仓库ID")
    private Long warehouseId;
    /** 逻辑仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "逻辑仓库编码")
    private String warehouseCode;
    /** 逻辑仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "逻辑仓库名称")
    private String warehouseName;
    /** 总数量 */
    @ApiModelProperty(name="totalQuantity",value = "总数量")
    private BigDecimal totalQuantity;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;
    /** 组织ID */
    @ApiModelProperty(name="organizationId",value = "组织ID")
    private Long organizationId;
    /** 组织名称 */
    @ApiModelProperty(name="organizationName",value = "组织名称")
    private String organizationName;
    /**
     * 创建时间 查询时间段
     */
    @ApiModelProperty(name = "createTimeStart", value = "创建时间")
    private String createTimeStart;
    /**
     * 创建时间 查询时间段
     */
    @ApiModelProperty(name = "createTimeEnd", value = "创建时间")
    private String createTimeEnd;
    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;
    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;
    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照createTime降序")
    private String orderByDesc = "createTime";

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Integer getSynchronousWms() {
        return synchronousWms;
    }

    public void setSynchronousWms(Integer synchronousWms) {
        this.synchronousWms = synchronousWms;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public BigDecimal getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getCreateTimeStart() {
        return createTimeStart;
    }

    public void setCreateTimeStart(String createTimeStart) {
        this.createTimeStart = createTimeStart;
    }

    public String getCreateTimeEnd() {
        return createTimeEnd;
    }

    public void setCreateTimeEnd(String createTimeEnd) {
        this.createTimeEnd = createTimeEnd;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }
}