/**
 * @(#)CsDeliveryNoticeOrderAddReqDto.java 1.0 2021/12/29 11:08
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order;

import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.base.ContactDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author jingran
 * @Description CsDeliveryNoticeOrderAddReqDto
 * @Date: 2021/12/29 11:08
 * @since 1.0.0
 */
@ApiModel(value = "csDeliveryNoticeOrderAddReqDto", description = "新增Dto")
public class CsDeliveryNoticeOrderAddReqDto implements Serializable {

    /**
     * 发货通知单号
     */
    @ApiModelProperty(name = "documentNo", value = "发货通知单号")
    private String documentNo;
    /**
     * 关联单据号
     */
    @ApiModelProperty(name = "relevanceNo", value = "关联单据号")
    private String relevanceNo;
    /**
     * wms单号
     */
    @ApiModelProperty(name = "wmsNo", value = "wms单号")
    private String wmsNo;
    /**
     * 前置单号
     */
    @ApiModelProperty(name = "preOrderNo", value = "前置单号")
    private String preOrderNo;

    /**
     * 外部单号
     */
    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;
    /**
     * 业务类型
     */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;
    /**
     * 单据状态,待定
     */
    @ApiModelProperty(name = "orderStatus", value = "单据状态,待定")
    private String orderStatus;
    /**
     * 发货店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "发货店铺ID")
    private Long shopId;
    /**
     * 发货店铺编码
     */
    @ApiModelProperty(name = "shopCode", value = "发货店铺编码")
    private String shopCode;
    /**
     * 发货店铺名称
     */
    @ApiModelProperty(name = "shopName", value = "发货店铺名称")
    private String shopName;
    /**
     * 发货仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "发货仓库ID")
    private Long warehouseId;
    /**
     * 发货仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "发货仓库编码")
    private String warehouseCode;
    /**
     * 发货仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = "发货仓库名称")
    private String warehouseName;
    /**
     * 仓库分类,physics-物理仓,logic-逻辑仓
     */
    @ApiModelProperty(name = "warehouseClassify", value = "仓库分类,physics-物理仓,logic-逻辑仓")
    private String warehouseClassify;

    /**
     * 物理发货仓库编码
     */
    @ApiModelProperty(name = "deliveryPhysicsWarehouseCode", value = "物理发货仓库编码")
    private String deliveryPhysicsWarehouseCode;
    /**
     * 物理发货仓库名称
     */
    @ApiModelProperty(name = "deliveryPhysicsWarehouseName", value = "物理发货仓库名称")
    private String deliveryPhysicsWarehouseName;

    /**
     *  逻辑收货仓库编码
     */
    @ApiModelProperty(name = "receiveLogicWarehouseCode", value = "逻辑收货仓库编码")
    private String receiveLogicWarehouseCode;
    /**
     * 逻辑收货仓库名称
     */
    @ApiModelProperty(name = "receiveLogicWarehouseName", value = "逻辑收货仓库名称")
    private String receiveLogicWarehouseName;

    /**
     * 发货总数量
     */
    @ApiModelProperty(name = "totalQuantity", value = "发货总数量")
    private BigDecimal totalQuantity;
    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    @ApiModelProperty(name = "contactDto", value = "前置单据的冗余信息")
    private ContactDto contactDto;

    @ApiModelProperty(name = "detailAddReqDtoList", value = "货品详情")
    private List<CsDeliveryNoticeOrderDetailAddReqDto> detailAddReqDtoList;

    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    @ApiModelProperty(name="noBatch",value = "原单是否不带批次：1.是，0或空.否")
    private Integer noBatch;

    @ApiModelProperty(name="bizDate",value = "业务时间")
    private Date bizDate;

    public Date getBizDate() {
        return bizDate;
    }

    public void setBizDate(Date bizDate) {
        this.bizDate = bizDate;
    }

    public Integer getNoBatch() {
        return noBatch;
    }

    public void setNoBatch(Integer noBatch) {
        this.noBatch = noBatch;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }
    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getExternalOrderNo() {
        return externalOrderNo;
    }

    public void setExternalOrderNo(String externalOrderNo) {
        this.externalOrderNo = externalOrderNo;
    }

    public ContactDto getContactDto() {
        return contactDto;
    }

    public void setContactDto(ContactDto contactDto) {
        this.contactDto = contactDto;
    }

    public List<CsDeliveryNoticeOrderDetailAddReqDto> getDetailAddReqDtoList() {
        return detailAddReqDtoList;
    }

    public void setDetailAddReqDtoList(List<CsDeliveryNoticeOrderDetailAddReqDto> detailAddReqDtoList) {
        this.detailAddReqDtoList = detailAddReqDtoList;
    }

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getRelevanceNo() {
        return relevanceNo;
    }

    public void setRelevanceNo(String relevanceNo) {
        this.relevanceNo = relevanceNo;
    }

    public String getPreOrderNo() {
        return preOrderNo;
    }

    public void setPreOrderNo(String preOrderNo) {
        this.preOrderNo = preOrderNo;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }


    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public BigDecimal getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getDeliveryPhysicsWarehouseCode() {
        return deliveryPhysicsWarehouseCode;
    }

    public void setDeliveryPhysicsWarehouseCode(String deliveryPhysicsWarehouseCode) {
        this.deliveryPhysicsWarehouseCode = deliveryPhysicsWarehouseCode;
    }

    public String getDeliveryPhysicsWarehouseName() {
        return deliveryPhysicsWarehouseName;
    }

    public void setDeliveryPhysicsWarehouseName(String deliveryPhysicsWarehouseName) {
        this.deliveryPhysicsWarehouseName = deliveryPhysicsWarehouseName;
    }

    public String getReceiveLogicWarehouseCode() {
        return receiveLogicWarehouseCode;
    }

    public void setReceiveLogicWarehouseCode(String receiveLogicWarehouseCode) {
        this.receiveLogicWarehouseCode = receiveLogicWarehouseCode;
    }

    public String getReceiveLogicWarehouseName() {
        return receiveLogicWarehouseName;
    }

    public void setReceiveLogicWarehouseName(String receiveLogicWarehouseName) {
        this.receiveLogicWarehouseName = receiveLogicWarehouseName;
    }

    public String getWmsNo() {
        return wmsNo;
    }

    public void setWmsNo(String wmsNo) {
        this.wmsNo = wmsNo;
    }
}