/**
 * @(#)CsDeliveryNoticeOrderDetailQueryDto.java 1.0 2021/12/29 11:08
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
* @Description CsDeliveryNoticeOrderDetailQueryDto
*
* @author jingran
* @Date: 2021/12/29 11:08
* @since 1.0.0
*/
@ApiModel(value = "csDeliveryNoticeOrderDetailQueryDto", description = "查询Dto")
public class CsDeliveryNoticeOrderDetailQueryDto extends RequestDto {

    /** 发货通知单号 */
    @ApiModelProperty(name="documentNo",value = "发货通知单号")
    private String documentNo;
    /** 关联单据号 */
    @ApiModelProperty(name="relevanceNo",value = "关联单据号")
    private String relevanceNo;
    /** 前置单号 */
    @ApiModelProperty(name="preOrderNo",value = "前置单号")
    private String preOrderNo;

    /** 活动ID */
    @ApiModelProperty(name="activityId",value = "活动ID")
    private Long activityId;
    /** 货品ID */
    @ApiModelProperty(name="cargoId",value = "货品ID")
    private Long cargoId;
    /** 货品编码 */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;
    /** 货品名称 */
    @ApiModelProperty(name="cargoName",value = "货品名称")
    private String cargoName;
    /** 批次 */
    @ApiModelProperty(name="batch",value = "批次")
    private String batch;
    /** 计划发货数量 */
    @ApiModelProperty(name="planQuantity",value = "计划发货数量")
    private BigDecimal planQuantity;
    /** 待发货数量 */
    @ApiModelProperty(name="waitQuantity",value = "待发货数量")
    private BigDecimal waitQuantity;
    /** 已发货数量 */
    @ApiModelProperty(name="doneQuantity",value = "已发货数量")
    private BigDecimal doneQuantity;
    /** 取消数量 */
    @ApiModelProperty(name="cancelQuantity",value = "取消数量")
    private BigDecimal cancelQuantity;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;
    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;
    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照create_time降序")
    private String orderByDesc = "create_time";

    @ApiModelProperty(name = "identification",value = "标识发货通知单查询生产日期")
    private String identification;

    public String getIdentification() {
        return identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getRelevanceNo() {
        return relevanceNo;
    }

    public void setRelevanceNo(String relevanceNo) {
        this.relevanceNo = relevanceNo;
    }

    public String getPreOrderNo() {
        return preOrderNo;
    }

    public void setPreOrderNo(String preOrderNo) {
        this.preOrderNo = preOrderNo;
    }


    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public BigDecimal getPlanQuantity() {
        return planQuantity;
    }

    public void setPlanQuantity(BigDecimal planQuantity) {
        this.planQuantity = planQuantity;
    }

    public BigDecimal getWaitQuantity() {
        return waitQuantity;
    }

    public void setWaitQuantity(BigDecimal waitQuantity) {
        this.waitQuantity = waitQuantity;
    }

    public BigDecimal getDoneQuantity() {
        return doneQuantity;
    }

    public void setDoneQuantity(BigDecimal doneQuantity) {
        this.doneQuantity = doneQuantity;
    }

    public BigDecimal getCancelQuantity() {
        return cancelQuantity;
    }

    public void setCancelQuantity(BigDecimal cancelQuantity) {
        this.cancelQuantity = cancelQuantity;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }
}