/**
 * @(#)CsInventoryAdjustUpdateReqDto.java 1.0 2022/01/15 15:59
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order;

import com.dtyunxi.yundt.cube.center.data.api.dto.base.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @author jingran
 * @Description CsInventoryAdjustUpdateReqDto
 * @Date: 2022/01/15 15:59
 * @since 1.0.0
 */
@ApiModel(value = "csInventoryAdjustUpdateReqDto", description = "修改Dto")
public class CsInventoryAdjustUpdateReqDto extends BaseReqDto {

    /**
     * 调整单号
     */
    @ApiModelProperty(name = "documentNo", value = "调整单号")
    private String documentNo;
    /**
     * 单据状态：3011-待审核，3012-已调整，3013-审批拒绝
     */
    @ApiModelProperty(name = "orderStatus", value = "单据状态：3011-待审核，3012-已调整，3013-审批拒绝")
    private String orderStatus;
    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     * 仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     * 仓库分类,physics-物理仓,logic-逻辑仓
     */
    @ApiModelProperty(name = "warehouseClassify", value = "仓库分类,physics-物理仓,logic-逻辑仓")
    private String warehouseClassify;
    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    @ApiModelProperty(name = "adjustDetailAddReqDtoList", value = "调整货品明细")
    private List<CsInventoryAdjustDetailAddReqDto> adjustDetailAddReqDtoList;

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<CsInventoryAdjustDetailAddReqDto> getAdjustDetailAddReqDtoList() {
        return adjustDetailAddReqDtoList;
    }

    public void setAdjustDetailAddReqDtoList(List<CsInventoryAdjustDetailAddReqDto> adjustDetailAddReqDtoList) {
        this.adjustDetailAddReqDtoList = adjustDetailAddReqDtoList;
    }
}