package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order;

import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsReceiveReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.basics.CsBasicsOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInOutResultRespDto;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 业务单据回调的请求参数
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/5/16 10:04 下午
 */
public class CsOrderBusinessCallBackContext implements Serializable {

    /**
     * 单据号
     **/
    @ApiModelProperty(name = "documentNo", value = "单据号")
    private String documentNo;

    /**
     * 出入库通知单号
     **/
    @ApiModelProperty(name = "inOutNoticeNo", value = "出入库通知单号")
    private String inOutNoticeNo;
    /**
     * 操作人
     **/
    @ApiModelProperty(name = "operatePerson", value = "操作人")
    private String operatePerson;
    /**
     * 备注
     **/
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /**
     * 出入库标识   true:入库    false:出库
     **/
    @ApiModelProperty(name = "inFlag", value = "出入库标识   true:入库    false:出库")
    private Boolean inFlag = false;


    /**
     * 超收标识，true：超发/收  false：正常
     **/
    @ApiModelProperty(name = "overchargeFlag", value = "超收标识，true：超收  false：正常")
    private Boolean overchargeFlag = false;


    /**
     * 部分入库标识，true：部分出/入库  false：正常
     **/
    @ApiModelProperty(name = "overchargeFlag", value = "部分入库标识，true：部分入库  false：正常")
    private Boolean portionFlag = false;

    /**
     * 关联单据号
     **/
    @ApiModelProperty(name = "relevanceNo", value = "关联单据号")
    private String relevanceNo;

    /**
     * 生成的出入库结果单单据信息
     **/
    @ApiModelProperty(name = "csOutResultOrderRespDto", value = "生成的出入库结果单单据信息")
    CsInOutResultRespDto csInOutResultRespDto;

    /**
     * 生成的收发货结果单单据信息
     **/
    @ApiModelProperty(name = "csDeliveryReceiveResultRespDto", value = "生成的收发货结果单单据信息")
    CsDeliveryReceiveResultRespDto csDeliveryReceiveResultRespDto;

    /**
     * 入库结果单单号
     **/
    @ApiModelProperty(name = "inResultOrderNo", value = "入库结果单单号")
    private String inResultOrderNo;

    /**
     * 收发货结果单单号
     **/
    @ApiModelProperty(name = "deliveryReceiveResultOrderNo", value = "收发货结果单单号")
    private String deliveryReceiveResultOrderNo;

    /**
     * 基础单据DTO信息
     **/
    @ApiModelProperty(name = "csBasicsOrderReqDto", value = "基础单据DTO信息")
    private CsBasicsOrderReqDto csBasicsOrderReqDto;

    /**
     * true:直接根据出入库结果单解挂        false:数据调整之后进行解挂
     **/
    @ApiModelProperty(name = "relieveFlag", value = "true:直接根据出入库结果单解挂        false:数据调整之后进行解挂")
    private Boolean relieveFlag;

    /**
     * WMS回传的基础DTO信息
     **/
    @ApiModelProperty(name = "basicsReceiveBasicsReqDto", value = "WMS回传的基础DTO信息")
    private CsBasicsReceiveReqDto basicsReceiveBasicsReqDto;

    /**
     * 取消操作专属
     */
    @ApiModelProperty(name = "onlyNodeCancel", value = "仅节点取消（不更新主单状态，不发通知）：true-是，false-否 默认否")
    private Boolean onlyNodeCancel=false;

    /**
     * 出入库通知单专属标识（定制内容 虚拟逻辑仓无需通知wms）
     */
    @ApiModelProperty(name = "noSendWms", value = "是否需推送wms:ture-需推送，false-无需推送 默认需推送")
    private Boolean sendWms=true;

    @ApiModelProperty(name = "enableAdjustInTransit", value = "是否开启在途调整单")
    private Boolean enableAdjustInTransit = Boolean.FALSE;

    public Boolean getSendWms() {
        return sendWms;
    }

    public void setSendWms(Boolean sendWms) {
        this.sendWms = sendWms;
    }

    public Boolean getOnlyNodeCancel() {
        return onlyNodeCancel;
    }

    public void setOnlyNodeCancel(Boolean onlyNodeCancel) {
        this.onlyNodeCancel = onlyNodeCancel;
    }

    public String getOperatePerson() {
        return operatePerson;
    }

    public void setOperatePerson(String operatePerson) {
        this.operatePerson = operatePerson;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getInOutNoticeNo() {
        return inOutNoticeNo;
    }

    public void setInOutNoticeNo(String inOutNoticeNo) {
        this.inOutNoticeNo = inOutNoticeNo;
    }

    public Boolean getOverchargeFlag() {
        return overchargeFlag;
    }

    public void setOverchargeFlag(Boolean overchargeFlag) {
        this.overchargeFlag = overchargeFlag;
    }

    public Boolean getPortionFlag() {
        return portionFlag;
    }

    public void setPortionFlag(Boolean portionFlag) {
        this.portionFlag = portionFlag;
    }

    public String getRelevanceNo() {
        return relevanceNo;
    }

    public void setRelevanceNo(String relevanceNo) {
        this.relevanceNo = relevanceNo;
    }

    public String getInResultOrderNo() {
        return inResultOrderNo;
    }

    public void setInResultOrderNo(String inResultOrderNo) {
        this.inResultOrderNo = inResultOrderNo;
    }

    public CsBasicsOrderReqDto getCsBasicsOrderReqDto() {
        return csBasicsOrderReqDto;
    }

    public void setCsBasicsOrderReqDto(CsBasicsOrderReqDto csBasicsOrderReqDto) {
        this.csBasicsOrderReqDto = csBasicsOrderReqDto;
    }

    public CsInOutResultRespDto getCsInOutResultRespDto() {
        return csInOutResultRespDto;
    }

    public void setCsInOutResultRespDto(CsInOutResultRespDto csInOutResultRespDto) {
        this.csInOutResultRespDto = csInOutResultRespDto;
    }

    public CsDeliveryReceiveResultRespDto getCsDeliveryReceiveResultRespDto() {
        return csDeliveryReceiveResultRespDto;
    }

    public void setCsDeliveryReceiveResultRespDto(CsDeliveryReceiveResultRespDto csDeliveryReceiveResultRespDto) {
        this.csDeliveryReceiveResultRespDto = csDeliveryReceiveResultRespDto;
    }

    public Boolean getInFlag() {
        return inFlag;
    }

    public void setInFlag(Boolean inFlag) {
        this.inFlag = inFlag;
    }

    public String getDeliveryReceiveResultOrderNo() {
        return deliveryReceiveResultOrderNo;
    }

    public void setDeliveryReceiveResultOrderNo(String deliveryReceiveResultOrderNo) {
        this.deliveryReceiveResultOrderNo = deliveryReceiveResultOrderNo;
    }

    public Boolean getRelieveFlag() {
        return relieveFlag;
    }

    public void setRelieveFlag(Boolean relieveFlag) {
        this.relieveFlag = relieveFlag;
    }

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public CsBasicsReceiveReqDto getBasicsReceiveBasicsReqDto() {
        return basicsReceiveBasicsReqDto;
    }

    public void setBasicsReceiveBasicsReqDto(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        this.basicsReceiveBasicsReqDto = basicsReceiveBasicsReqDto;
    }

    public Boolean getEnableAdjustInTransit() {
        return enableAdjustInTransit;
    }

    public void setEnableAdjustInTransit(Boolean enableAdjustInTransit) {
        this.enableAdjustInTransit = enableAdjustInTransit;
    }
}
