/**
 * @(#)CsOutResultOrderAddReqDto.java 1.0 2021/12/29 11:13
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author jinger
 * @since 1.0.0
 */
@ApiModel(value = "CsOutResultOrderStringValidReqDto", description = "出库结果单串码校验请求dto")
@Data
public class CsOutResultOrderStringValidReqDto implements Serializable {

    /**
     * 前置单号
     */
    @ApiModelProperty(name = "preOrderNo", value = "前置单号")
    private String preOrderNo;
    /**
     * 外部单号
     */
    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;

    /**
     * 单据类型：out-出库结果单，in-入库结果单
     */
    @ApiModelProperty(name = "orderType", value = "单据类型：out-出库结果单，in-入库结果单")
    private String orderType;

    /**
     * 串码校验结果
     */
    @ApiModelProperty(name = "stringValidResult", value = "串码校验结果")
    private String stringValidResult;

}