package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.basics;

import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 单据基础明细操作DTO
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/5/10 4:14 下午
 */
public class CsBasicsOrderDetailReqDto implements Serializable {

    /**
     * 商品长编码
     * 商品长编码必传，唯一
     **/
    @NotNull(message = "商品长编码不能为空")
    @ApiModelProperty(name = "longCode", value = "商品长编码", required = true)
    private String longCode;

    @ApiModelProperty(name = "cargoCode", value = "商品编码", required = false)
    private String cargoCode;

    /**
     * 商品名称
     * 可不传，底层会查询一次
     **/
    @ApiModelProperty(name = "itemName", value = "商品名称", required = false)
    private String itemName;

    /**
     * 批次
     * 有就传，没有就不传
     **/
    @ApiModelProperty(name = "batch", value = "批次", required = false)
    private String batch;

    /**
     * 货品货号
     **/
    @ApiModelProperty(name = "artNo", value = "货品货号", required = false)
    private String artNo;

    /**
     * 数量
     * 必传
     **/
    @NotNull(message = "货品数量不能为空")
    @ApiModelProperty(name = "quantity", value = "数量", required = true)
    private BigDecimal quantity;

    /**
     * 已发/收货数量
     */
    @ApiModelProperty(name = "doneQuantity", value = "已发/收货数量（特殊情況處理）", required = true)
    private BigDecimal doneQuantity;

    /**
     * 体积
     * 有就传没有就不传
     **/
    @ApiModelProperty(name = "volume", value = "体积", required = false)
    private BigDecimal volume;

    /**
     * 规格
     * 有就传没有就不传
     **/
    @ApiModelProperty(name = "specification", value = "规格", required = false)
    private String specification;

    /**
     * 生产日期
     **/
    @ApiModelProperty(name = "produceTime", value = "生产日期")
    private Date produceTime;

    /**
     * 过期日期
     **/
    @ApiModelProperty(name = "expireTime", value = "过期日期")
    private Date expireTime;

    /**
     * 扩展字段，不需要的字段，可以存入JSON数据
     **/
    @ApiModelProperty(name = "extension", value = "扩展字段，不需要的字段，可以存入JSON数据")
    private String extension;

    @ApiModelProperty(name = "tradeOrderItemId", value = "商品行明细id")
    private Long tradeOrderItemId;

    @ApiModelProperty(name = "preOrderItemId", value = "前置单商品行明细id")
    private Long preOrderItemId;

    public Long getPreOrderItemId() {
        return preOrderItemId;
    }

    public void setPreOrderItemId(Long preOrderItemId) {
        this.preOrderItemId = preOrderItemId;
    }

    public BigDecimal getDoneQuantity() {
        return doneQuantity;
    }

    public void setDoneQuantity(BigDecimal doneQuantity) {
        this.doneQuantity = doneQuantity;
    }

    public Long getTradeOrderItemId() {
        return tradeOrderItemId;
    }

    public void setTradeOrderItemId(Long tradeOrderItemId) {
        this.tradeOrderItemId = tradeOrderItemId;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public Date getProduceTime() {
        return produceTime;
    }

    public void setProduceTime(Date produceTime) {
        this.produceTime = produceTime;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public CsBasicsOrderDetailReqDto() {
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getVolume() {
        return volume;
    }

    public void setVolume(BigDecimal volume) {
        this.volume = volume;
    }

    public String getSpecification() {
        return specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }
}
