package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.basics;

import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsWmsShippingInfoReqDto;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 单据基础操作DTO
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/5/10 4:14 下午
 */
public class CsBasicsOrderReqDto implements Serializable {

    /**
     * 单据操作策略
     * com.dtyunxi.yundt.cube.center.inventory.enums.CsBasicsOrderStrategyEnum
     **/
    @ApiModelProperty(name = "strategy", value = "单据操作策略", required = true)
    private String strategy;

    /**
     * 单据操作策略
     * wms,eas
     **/
    @ApiModelProperty(name = "wmsStrategy", value = "wms单据操作策略", required = true)
    private String wmsStrategy;

    /**
     * 单据号
     * 如果需要外部自定义的，可以自己传入，不需要的话
     * 会根据具体的策略规则生成对应单号
     **/
    @ApiModelProperty(name = "documentNo", value = "单据号", required = false)
    private String documentNo;

    /**
     * 关联单据号
     * 关联单号必传，每一个业务单据都有对应的单号，传入进来后，
     * 基础单据就会关联上去
     **/
    @ApiModelProperty(name = "relevanceNo", value = "关联单据号", required = true)
    private String relevanceNo;

    /**
     * 前置单号
     * 针对于逻辑层收发货通知单的，前置单号可以为null，但是传入
     * 下层物理层的生成出入库通知单的，需要将上层收发货通知单的单号
     * 传入
     **/
    @ApiModelProperty(name = "preOrderNo", value = "前置单号", required = false)
    private String preOrderNo;

    /**
     * 外部单号
     * 业务单据可能来源于第三方，如果是来源于第三方的业务单据，则
     * 需要传入外部单号
     **/
    @ApiModelProperty(name = "externalOrderNo", value = "外部单号", required = false)
    private String externalOrderNo;

    /**
     * wms单号
     * 此单号只有WMS发货回传这种情况才会有值，其他情况基本不需要传
     **/
    @ApiModelProperty(name = "wmsOrderNo", value = "wms单号", required = false)
    private String wmsOrderNo;

    /**
     * 业务类型 com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum
     * 业务单据的业务类型
     **/
    @ApiModelProperty(name = "businessType", value = "业务类型", required = true)
    private String businessType;

    /**
     * 业务单据表名
     * 业务单据相关的表名，基础单据详情查询需要做关联，所以最好传一下
     **/
    @ApiModelProperty(name = "relevanceTableName", value = "业务单据表名", required = true)
    private String relevanceTableName;

    /**
     * 单据状态
     * 如果需要外部自定义的，可以自己传入，不需要的话
     * 会根据具体的策略规则赋值对应的单据状态
     **/
    @ApiModelProperty(name = "orderStatus", value = "单据状态")
    private String orderStatus;

    /**
     * 逻辑仓仓库编码
     * 针对逻辑层收发货单据,收发货通知单、结果单策略，编码必传
     **/
    @ApiModelProperty(name = "logicWarehouseCode", value = "逻辑仓仓库编码", required = false)
    private String logicWarehouseCode;

    /**
     * 逻辑仓仓库名称
     * 针对逻辑层收发货单据，名称可以不传
     **/
    @ApiModelProperty(name = "logicWarehouseName", value = "逻辑仓仓库名称", required = false)
    private String logicWarehouseName;

    /**
     * 物理仓仓库编码
     * 针对物理层出入库单据，出入库通知单、结果单类策略，编码必传
     **/
    @ApiModelProperty(name = "physicsWarehouseCode", value = "物理仓仓库编码", required = false)
    private String physicsWarehouseCode;

    /**
     * 物理仓仓库名称
     * 针对物理层收发货单据，名称可以不传
     **/
    @ApiModelProperty(name = "physicsWarehouseName", value = "物理仓仓库名称", required = false)
    private String physicsWarehouseName;


    /**
     * 操作标识  com.dtyunxi.yundt.cube.center.inventory.enums.CsBasicsOrderOperateTypeEnum
     * 操作标识一定需要传，不然区分不出是出入库以及收发货
     **/
    @ApiModelProperty(name = "basicsOrderOperateType", value = "操作标识", required = true)
    private String basicsOrderOperateType;

    /**
     * 来源单据类型  CsInventorySourceTypeEnum
     **/
    @ApiModelProperty(name = "sourceType", value = "来源单据类型")
    private String sourceType;

    /**
     * 收货地址/发货地址
     **/
    @ApiModelProperty(name = "address", value = "收货地址/发货地址")
    private String address;

    /**
     * 联系人
     **/
    @ApiModelProperty(name = "address", value = "联系人")
    private String contactName;

    /**
     * 联系电话
     **/
    @ApiModelProperty(name = "contactPhone", value = "联系电话")
    private String contactPhone;

    /**
     * 计划发货/收货时间
     **/
    @ApiModelProperty(name = "planTime", value = "计划发货/收货时间")
    private String planTime;

    /**
     * 是否变动逻辑库存标识
     */
    @ApiModelProperty(name = "changeLogicInventory", value = "是否变动逻辑库存标识,不默认变动")
    private Boolean changeLogicInventory = false;

    /**
     * 是否变动库存标识
     */
    @ApiModelProperty(name = "changeInventory", value = "是否变动物理库存标识,默认不变动")
    private Boolean changePhysicsInventory = false;

    /**
     * 是否生成单据
     */
    @ApiModelProperty(name = "generateNextOrderFlag", value = "是否生成联动单据")
    private Boolean generateNextOrderFlag = true;

    /**
     * 是否通知WMS
     */
    @ApiModelProperty(name = "noticeWms", value = "是否通知WMS")
    private Boolean noticeWms = true;

    /**
     * 总数量
     */
    @ApiModelProperty(name = "totalQuantity", value = "总数量")
    private BigDecimal totalQuantity;

    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /**
     * 明细信息
     * 明细信息必传
     **/
    @ApiModelProperty(name = "orderBasicsDetailReqDtoList", value = "明细信息", required = false)
    private List<CsBasicsOrderDetailReqDto> orderBasicsDetailReqDtoList;

    /**
     * 预占释放类型,流水表需要用到
     **/
    @ApiModelProperty(name = "preemptReleaseType", value = "预占释放类型,流水表需要用到")
    private String preemptReleaseType;

    /**
     * 入逻辑仓仓库编码
     * 针对逻辑层收发货单据,收发货通知单、结果单策略，编码必传
     **/
    @ApiModelProperty(name = "inLogicWarehouseCode", value = "逻辑仓仓库编码", required = false)
    private String inLogicWarehouseCode;

    /**
     * 入逻辑仓仓库名称
     * 针对逻辑层收发货单据，名称可以不传
     **/
    @ApiModelProperty(name = "inLogicWarehouseName", value = "逻辑仓仓库名称", required = false)
    private String inLogicWarehouseName;

    /**
     * 入物理仓仓库编码
     * 针对物理层出入库单据，出入库通知单、结果单类策略，编码必传
     **/
    @ApiModelProperty(name = "inPhysicsWarehouseCode", value = "物理仓仓库编码", required = false)
    private String inPhysicsWarehouseCode;

    /**
     * 入物理仓仓库名称
     * 针对物理层收发货单据，名称可以不传
     **/
    @ApiModelProperty(name = "inPhysicsWarehouseName", value = "物理仓仓库名称", required = false)
    private String inPhysicsWarehouseName;

    /**
     * 总箱数
     **/
    @ApiModelProperty(name = "totalCartons", value = "总箱数")
    private BigDecimal totalCartons;
    /**
     * 拼箱数
     **/
    @ApiModelProperty(name = "mergeQuantity", value = "拼箱数")
    private BigDecimal mergeQuantity;

    @ApiModelProperty(name = "shippingInfoReqDtoList", value = "物流信息")
    private List<CsWmsShippingInfoReqDto> shippingInfoReqDtoList;

    /**
     * 扩展字段，不需要的字段，可以存入JSON数据
     **/
    @ApiModelProperty(name = "extension", value = "扩展字段，不需要的字段，可以存入JSON数据")
    private String extension;

    @ApiModelProperty(name="sourceSystem",value = "来源系统")
    private String sourceSystem;


    /**
     * 推送的消息tag（需推送奇门wms消息发mq，必传此属性，不然没有tag） ExternalMqConstants
     */
    @ApiModelProperty(name = "messageTag", value = "推送的消息tag（需推送消息发mq，必传此属性，不然没有tag）")
    private String messageTag;

    @ApiModelProperty(name = "sendMessage", value = "true发送mq，false不发送mq")
    private Boolean sendMessage = true;
    /**
     * 物流商编码
     **/
    @ApiModelProperty(name = "shipmentEnterpriseCode", value = "物流商编码")
    private String shipmentEnterpriseCode;
    /**
     * 物流商名称
     **/
    @ApiModelProperty(name = "shipmentEnterpriseName", value = "物流商名称")
    private String shipmentEnterpriseName;

    /**
     * 来源于基础中心的字典业务类型枚举，北鼎用 com.dtyunxi.yundt.cube.center.data.api.enums.PcpBasicInventoryBusinessTypeEnum
     **/
    @ApiModelProperty(name = "basicDataBusinessType", value = "来源于基础中心的字典业务类型枚举，北鼎用 com.dtyunxi.yundt.cube.center.data.api.enums.PcpBasicInventoryBusinessTypeEnum")
    private String basicDataBusinessType;

    /**
     * 订单来源平台编码
     */
    @ApiModelProperty(name = "sourcePlatformCode", value = "订单来源平台编码（交易透传）")
    private String sourcePlatformCode;

    /**
     * 中台的上游的单号（如天猫、淘宝的平台单号）
     */
    @ApiModelProperty(name = "oaidOrderSourceCode", value = "中台的上游的单号（如天猫、淘宝的平台单号 交易透传）")
    private String oaidOrderSourceCode;

    /**
     * 订单支付时间（交易透传）
     */
    @ApiModelProperty(name = "payTime", value = "订单支付时间（交易透传）")
    private Date payTime;

    /**
     * 原单是否不带批次：1.是，0或空.否
     */
    @ApiModelProperty(name = "noBatch", value = "原单是否不带批次：1.是，0或空.否")
    private Integer noBatch;

    public Integer getNoBatch() {
        return noBatch;
    }

    public void setNoBatch(Integer noBatch) {
        this.noBatch = noBatch;
    }

    public String getSourceSystem() {
        return sourceSystem;
    }

    public void setSourceSystem(String sourceSystem) {
        this.sourceSystem = sourceSystem;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public BigDecimal getTotalCartons() {
        return totalCartons;
    }

    public void setTotalCartons(BigDecimal totalCartons) {
        this.totalCartons = totalCartons;
    }

    public BigDecimal getMergeQuantity() {
        return mergeQuantity;
    }

    public void setMergeQuantity(BigDecimal mergeQuantity) {
        this.mergeQuantity = mergeQuantity;
    }

    public List<CsWmsShippingInfoReqDto> getShippingInfoReqDtoList() {
        return shippingInfoReqDtoList;
    }

    public void setShippingInfoReqDtoList(List<CsWmsShippingInfoReqDto> shippingInfoReqDtoList) {
        this.shippingInfoReqDtoList = shippingInfoReqDtoList;
    }

    public String getInLogicWarehouseCode() {
        return inLogicWarehouseCode;
    }

    public void setInLogicWarehouseCode(String inLogicWarehouseCode) {
        this.inLogicWarehouseCode = inLogicWarehouseCode;
    }

    public String getInLogicWarehouseName() {
        return inLogicWarehouseName;
    }

    public void setInLogicWarehouseName(String inLogicWarehouseName) {
        this.inLogicWarehouseName = inLogicWarehouseName;
    }

    public String getInPhysicsWarehouseCode() {
        return inPhysicsWarehouseCode;
    }

    public void setInPhysicsWarehouseCode(String inPhysicsWarehouseCode) {
        this.inPhysicsWarehouseCode = inPhysicsWarehouseCode;
    }

    public String getInPhysicsWarehouseName() {
        return inPhysicsWarehouseName;
    }

    public void setInPhysicsWarehouseName(String inPhysicsWarehouseName) {
        this.inPhysicsWarehouseName = inPhysicsWarehouseName;
    }

    public String getPreemptReleaseType() {
        return preemptReleaseType;
    }

    public void setPreemptReleaseType(String preemptReleaseType) {
        this.preemptReleaseType = preemptReleaseType;
    }


    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public BigDecimal getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public Boolean getChangeLogicInventory() {
        return changeLogicInventory;
    }

    public void setChangeLogicInventory(Boolean changeLogicInventory) {
        this.changeLogicInventory = changeLogicInventory;
    }

    public Boolean getChangePhysicsInventory() {
        return changePhysicsInventory;
    }

    public void setChangePhysicsInventory(Boolean changePhysicsInventory) {
        this.changePhysicsInventory = changePhysicsInventory;
    }

    public Boolean getGenerateNextOrderFlag() {
        return generateNextOrderFlag;
    }

    public void setGenerateNextOrderFlag(Boolean generateNextOrderFlag) {
        this.generateNextOrderFlag = generateNextOrderFlag;
    }

    public Boolean getNoticeWms() {
        return noticeWms;
    }

    public void setNoticeWms(Boolean noticeWms) {
        this.noticeWms = noticeWms;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getContactName() {
        return contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public String getPlanTime() {
        return planTime;
    }

    public void setPlanTime(String planTime) {
        this.planTime = planTime;
    }

    public String getWmsStrategy() {
        return wmsStrategy;
    }

    public void setWmsStrategy(String wmsStrategy) {
        this.wmsStrategy = wmsStrategy;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public CsBasicsOrderReqDto() {
    }

    public String getStrategy() {
        return strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getRelevanceNo() {
        return relevanceNo;
    }

    public void setRelevanceNo(String relevanceNo) {
        this.relevanceNo = relevanceNo;
    }

    public String getPreOrderNo() {
        return preOrderNo;
    }

    public void setPreOrderNo(String preOrderNo) {
        this.preOrderNo = preOrderNo;
    }

    public String getExternalOrderNo() {
        return externalOrderNo;
    }

    public void setExternalOrderNo(String externalOrderNo) {
        this.externalOrderNo = externalOrderNo;
    }

    public String getWmsOrderNo() {
        return wmsOrderNo;
    }

    public void setWmsOrderNo(String wmsOrderNo) {
        this.wmsOrderNo = wmsOrderNo;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getRelevanceTableName() {
        return relevanceTableName;
    }

    public void setRelevanceTableName(String relevanceTableName) {
        this.relevanceTableName = relevanceTableName;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getLogicWarehouseCode() {
        return logicWarehouseCode;
    }

    public void setLogicWarehouseCode(String logicWarehouseCode) {
        this.logicWarehouseCode = logicWarehouseCode;
    }

    public String getLogicWarehouseName() {
        return logicWarehouseName;
    }

    public void setLogicWarehouseName(String logicWarehouseName) {
        this.logicWarehouseName = logicWarehouseName;
    }

    public String getPhysicsWarehouseCode() {
        return physicsWarehouseCode;
    }

    public void setPhysicsWarehouseCode(String physicsWarehouseCode) {
        this.physicsWarehouseCode = physicsWarehouseCode;
    }

    public String getPhysicsWarehouseName() {
        return physicsWarehouseName;
    }

    public void setPhysicsWarehouseName(String physicsWarehouseName) {
        this.physicsWarehouseName = physicsWarehouseName;
    }

    public List<CsBasicsOrderDetailReqDto> getOrderBasicsDetailReqDtoList() {
        return orderBasicsDetailReqDtoList;
    }

    public void setOrderBasicsDetailReqDtoList(List<CsBasicsOrderDetailReqDto> orderBasicsDetailReqDtoList) {
        this.orderBasicsDetailReqDtoList = orderBasicsDetailReqDtoList;
    }

    public String getBasicsOrderOperateType() {
        return basicsOrderOperateType;
    }

    public void setBasicsOrderOperateType(String basicsOrderOperateType) {
        this.basicsOrderOperateType = basicsOrderOperateType;
    }

    public String getMessageTag() {
        return messageTag;
    }

    public void setMessageTag(String messageTag) {
        this.messageTag = messageTag;
    }

    public Boolean getSendMessage() {
        return sendMessage;
    }

    public void setSendMessage(Boolean sendMessage) {
        this.sendMessage = sendMessage;
    }

    public String getShipmentEnterpriseCode() {
        return shipmentEnterpriseCode;
    }

    public void setShipmentEnterpriseCode(String shipmentEnterpriseCode) {
        this.shipmentEnterpriseCode = shipmentEnterpriseCode;
    }

    public String getShipmentEnterpriseName() {
        return shipmentEnterpriseName;
    }

    public void setShipmentEnterpriseName(String shipmentEnterpriseName) {
        this.shipmentEnterpriseName = shipmentEnterpriseName;
    }

    public String getBasicDataBusinessType() {
        return basicDataBusinessType;
    }

    public void setBasicDataBusinessType(String basicDataBusinessType) {
        this.basicDataBusinessType = basicDataBusinessType;
    }

    public String getSourcePlatformCode() {
        return sourcePlatformCode;
    }

    public void setSourcePlatformCode(String sourcePlatformCode) {
        this.sourcePlatformCode = sourcePlatformCode;
    }

    public String getOaidOrderSourceCode() {
        return oaidOrderSourceCode;
    }

    public void setOaidOrderSourceCode(String oaidOrderSourceCode) {
        this.oaidOrderSourceCode = oaidOrderSourceCode;
    }

    public Date getPayTime() {
        return payTime;
    }

    public void setPayTime(Date payTime) {
        this.payTime = payTime;
    }
}
