package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.basics;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 单据基础操作DTO
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/5/10 4:14 下午
 */
@Data
@ApiModel(value = "CsCommonBasicsOrderReqDto", description = "公共单据基础操作DTO")
public class CsCommonBasicsOrderReqDto implements Serializable {
    /**
     * 单据操作策略
     * com.dtyunxi.yundt.cube.center.inventory.enums.CsBasicsOrderStrategyEnum
     **/
    @NotNull(message = "单据操作策略不能为空")
    @ApiModelProperty(name = "strategy", value = "单据操作策略【CsBasicsOrderStrategyEnum】", required = true)
    private String strategy;
    /**
     * 关联单据号
     * 关联单号必传，每一个业务单据都有对应的单号，传入进来后，
     * 基础单据就会关联上去
     **/
    @NotNull(message = "关联单据号不能为空")
    @ApiModelProperty(name = "relevanceNo", value = "关联单据号", required = true)
    private String relevanceNo;

    /**
     * 前置单号
     * 针对于逻辑层收发货通知单的，前置单号可以为null，但是传入
     * 下层物理层的生成出入库通知单的，需要将上层收发货通知单的单号
     * 传入
     **/
    @ApiModelProperty(name = "preOrderNo", value = "前置单号", required = false)
    private String preOrderNo;

    /**
     * 外部单号
     * 业务单据可能来源于第三方，如果是来源于第三方的业务单据，则
     * 需要传入外部单号
     **/
    @ApiModelProperty(name = "externalOrderNo", value = "外部单号", required = false)
    private String externalOrderNo;

    /**
     * 业务类型 com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum
     * 业务单据的业务类型
     **/
    @NotNull(message = "业务类型不能为空")
    @ApiModelProperty(name = "businessType", value = "业务类型", required = true)
    private String businessType;

    /**
     * 业务单据表名
     * 业务单据相关的表名，基础单据详情查询需要做关联，所以最好传一下
     **/
    @NotNull(message = "业务单据表名不能为空")
    @ApiModelProperty(name = "relevanceTableName", value = "业务单据表名【CsRelevanceTableNameEnum】", required = true)
    private String relevanceTableName;

    /**
     * 操作标识  com.dtyunxi.yundt.cube.center.inventory.enums.CsBasicsOrderOperateTypeEnum
     * 操作标识一定需要传，不然区分不出是出入库以及收发货
     **/
    @NotNull(message = "操作标识不能为空")
    @ApiModelProperty(name = "basicsOrderOperateType", value = "操作标识（收发货）【CsBasicsOrderOperateTypeEnum】", required = true)
    private String basicsOrderOperateType;

    /**
     * 逻辑仓仓库编码
     * 针对逻辑层收发货单据,收发货通知单、结果单策略，编码必传
     **/
    @NotNull(message = "逻辑仓仓库编码不能为空")
    @ApiModelProperty(name = "logicWarehouseCode", value = "逻辑仓仓库编码", required = false)
    private String logicWarehouseCode;

    /**
     * 逻辑仓仓库名称
     * 针对逻辑层收发货单据，名称可以不传
     **/
    @ApiModelProperty(name = "logicWarehouseName", value = "逻辑仓仓库名称", required = false)
    private String logicWarehouseName;


    /**
     * 收货地址/发货地址
     **/
    @ApiModelProperty(name = "address", value = "收货地址/发货地址")
    private String address;

    /**
     * 联系人
     **/
    @ApiModelProperty(name = "address", value = "联系人")
    private String contactName;

    /**
     * 联系电话
     **/
    @ApiModelProperty(name = "contactPhone", value = "联系电话")
    private String contactPhone;

    /**
     * 计划发货/收货时间
     **/
    @ApiModelProperty(name = "planTime", value = "计划发货/收货时间")
    private String planTime;
    /**
     * 总箱数
     **/
    @ApiModelProperty(name = "totalCartons", value = "总箱数")
    private BigDecimal totalCartons;
    /**
     * 拼箱数
     **/
    @ApiModelProperty(name = "mergeQuantity", value = "拼箱数")
    private BigDecimal mergeQuantity;
    /**
     * 扩展字段，不需要的字段，可以存入JSON数据
     **/
    @ApiModelProperty(name = "extension", value = "扩展字段，不需要的字段，可以存入JSON数据")
    private String extension;

    @ApiModelProperty(name = "sourceSystem", value = "来源系统")
    private String sourceSystem;
    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    @ApiModelProperty(name = "generateNextOrderFlag", value = "是否生成联动单据")
    private Boolean generateNextOrderFlag = true;
    /**
     * 明细信息
     * 明细信息必传
     **/
    @NotNull(message = "货品明细信息不能为空")
    @Valid
    @ApiModelProperty(name = "orderBasicsDetailReqDtoList", value = "明细信息", required = false)
    private List<CsBasicsOrderDetailReqDto> orderBasicsDetailReqDtoList;

}
