/**
 * @(#)CsInPlannedOrderAddReqDto.java 1.0 2022/04/13 15:39
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 **/
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.basics;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * @author jingran
 * @Description CsInPlannedOrderAddReqDto
 * @Date: 2022/04/13 15:39
 * @since 1.0.0
 **/
@ApiModel(value = "CsOverchargeAdjustReqDto", description = "超收数据调整DTO")
public class CsOverchargeAdjustReqDto implements Serializable {

    /**
     * 入库结果单单号
     **/
    @ApiModelProperty(name = "inResultDocumentNo", value = "入库结果单单号")
    private String inResultDocumentNo;

    /**
     * 商品明细信息
     **/
    @ApiModelProperty(name = "detailReqDtoList", value = "商品明细信息")
    private List<CsOverchargeAdjustDetailReqDto> detailReqDtoList;

    /**
     * 备注
     **/
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /**
     * 操作标识  com.dtyunxi.yundt.cube.center.inventory.enums.CsBasicsOrderOperateTypeEnum
     *
     **/
    @ApiModelProperty(name = "basicsOrderOperateType", value = "操作标识")
    private String basicsOrderOperateType;

    public CsOverchargeAdjustReqDto() {
    }

    public String getInResultDocumentNo() {
        return inResultDocumentNo;
    }

    public void setInResultDocumentNo(String inResultDocumentNo) {
        this.inResultDocumentNo = inResultDocumentNo;
    }

    public List<CsOverchargeAdjustDetailReqDto> getDetailReqDtoList() {
        return detailReqDtoList;
    }

    public void setDetailReqDtoList(List<CsOverchargeAdjustDetailReqDto> detailReqDtoList) {
        this.detailReqDtoList = detailReqDtoList;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getBasicsOrderOperateType() {
        return basicsOrderOperateType;
    }

    public void setBasicsOrderOperateType(String basicsOrderOperateType) {
        this.basicsOrderOperateType = basicsOrderOperateType;
    }
}