/**
 * @(#)CsInPlannedOrderAddReqDto.java 1.0 2022/04/13 15:39
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 **/
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 对外暴露第三方接口生成计划单据货品明细DTO
 *
 * @author jingran
 * @Description CsInPlannedOrderAddReqDto
 * @Date: 2022/04/13 15:39
 * @since 1.0.0
 **/
@ApiModel(value = "CsInPlannedOrderGenerateDetailExposedReqDto", description = "对外暴露第三方接口生成计划单据货品明细DTO")
public class CsInPlannedOrderGenerateDetailExposedReqDto implements Serializable {

    /**
     * 商品长编码
     **/
    @ApiModelProperty(name = "skuCode", value = "商品长编码")
    private String skuCode;
    /**
     * 商品数量
     **/
    @ApiModelProperty(name = "quantity", value = "商品数量")
    private BigDecimal quantity;
    /**
     * 批次
     **/
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
     * 扩展字段，不需要的字段，可以存入JSON数据
     **/
    @ApiModelProperty(name = "extension", value = "扩展字段，不需要的字段，可以存入JSON数据")
    private String extension;
    /**
     * 仓库编码
     **/
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;

    /**
     *  过期日期
     */
    @ApiModelProperty(name = "expireTime", value = "过期日期")
    private Date expireTime;

    /**
     *  生产日期
     */
    @ApiModelProperty(name = "produceTime", value = "生产日期")
    private Date produceTime;


    public CsInPlannedOrderGenerateDetailExposedReqDto() {
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Date getProduceTime() {
        return produceTime;
    }

    public void setProduceTime(Date produceTime) {
        this.produceTime = produceTime;
    }
}