/**
 * @(#)CsInPlannedOrderAddReqDto.java 1.0 2022/04/13 15:39
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 **/
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in;

import com.dtyunxi.yundt.cube.center.data.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author jingran
 * @Description CsInPlannedOrderAddReqDto
 * @Date: 2022/04/13 15:39
 * @since 1.0.0
 **/
@ApiModel(value = "csInPlannedOrderGenerateReqDto", description = "生成单据DTO")
public class CsInPlannedOrderGenerateDetailReqDto extends BaseDto implements Serializable {

    /**
     * 商品长编码
     **/
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;

    /**
     * 商品数量
     **/
    @ApiModelProperty(name = "planQuantity", value = "商品数量")
    private BigDecimal planQuantity;

    /**
     * 批次
     **/
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;

    /**
     *  过期日期
     */
    @ApiModelProperty(name = "expireTime", value = "过期日期")
    private Date expireTime;

    /**
     *  生产日期
     */
    @ApiModelProperty(name = "produceTime", value = "生产日期")
    private Date produceTime;

    //====================外部无需关注的字段
    /**
     * 货品ID
     **/
    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;

    /**
     * 货品编码
     **/
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    /**
     * 货品名称
     **/
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;

    /**
     * 商品货号
     */
    @ApiModelProperty(name = "artNo", value = "商品货号")
    private String artNo;


    public CsInPlannedOrderGenerateDetailReqDto() {
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public BigDecimal getPlanQuantity() {
        return planQuantity;
    }

    public void setPlanQuantity(BigDecimal planQuantity) {
        this.planQuantity = planQuantity;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Date getProduceTime() {
        return produceTime;
    }

    public void setProduceTime(Date produceTime) {
        this.produceTime = produceTime;
    }
}