/**
 * @(#)CsInPlannedOrderAddReqDto.java 1.0 2022/04/13 15:39
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 **/
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in;

import com.dtyunxi.yundt.cube.center.data.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 对外暴露第三方接口生成计划单据DTO
 *
 * @author jingran
 * @Description CsInPlannedOrderAddReqDto
 * @Date: 2022/04/13 15:39
 * @since 1.0.0
 **/
@ApiModel(value = "CsInPlannedOrderGenerateExposedReqDto", description = "对外暴露第三方接口生成计划单据DTO")
public class CsInPlannedOrderGenerateExposedReqDto extends BaseDto implements Serializable {

    /**
     * 平台单号(来源于第三方系统),如果是第三方新建的，需要传入
     **/
    @ApiModelProperty(name = "platformOrderNo", value = "平台单号(来源于第三方系统)")
    private String platformOrderNo;
    /**
     * 单据类型:purchase-采购订单,outsource-委外订单,production-生产订单
     * com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum
     **/
    @ApiModelProperty(name = "orderType", value = "单据类型:purchase-采购订单,outsource-委外订单,production-生产订单")
    private String orderType;
    /**
     * 供应商编码
     **/
    @ApiModelProperty(name = "supplierCode", value = "供应商编码")
    private String supplierCode;
    /**
     * 备注
     **/
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /**
     * 扩展字段，不需要的字段，可以存入JSON数据
     **/
    @ApiModelProperty(name = "extension", value = "扩展字段，不需要的字段，可以存入JSON数据")
    private String extension;

    /**
     * 商品明细信息
     **/
    @ApiModelProperty(name = "itemDetailList", value = "商品明细信息")
    private List<CsInPlannedOrderGenerateDetailExposedReqDto> itemDetailList;

    @ApiModelProperty(name="sourceSystem",value = "来源系统")
    private String sourceSystem;

    public String getSourceSystem() {
        return sourceSystem;
    }

    public void setSourceSystem(String sourceSystem) {
        this.sourceSystem = sourceSystem;
    }

    public String getPlatformOrderNo() {
        return platformOrderNo;
    }

    public void setPlatformOrderNo(String platformOrderNo) {
        this.platformOrderNo = platformOrderNo;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public List<CsInPlannedOrderGenerateDetailExposedReqDto> getItemDetailList() {
        return itemDetailList;
    }

    public void setItemDetailList(List<CsInPlannedOrderGenerateDetailExposedReqDto> itemDetailList) {
        this.itemDetailList = itemDetailList;
    }
}