/**
 * @(#)CsInPlannedOrderAddReqDto.java 1.0 2022/04/13 15:39
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 **/
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in;

import com.dtyunxi.yundt.cube.center.data.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author jingran
 * @Description CsInPlannedOrderAddReqDto
 * @Date: 2022/04/13 15:39
 * @since 1.0.0
 **/
@ApiModel(value = "csInPlannedOrderGenerateReqDto", description = "生成单据DTO")
public class CsInPlannedOrderGenerateReqDto extends BaseDto implements Serializable {

    /**
     * 编辑重新提交
     **/
    @ApiModelProperty(name = "orderNo", value = "编辑重新提交")
    private String orderNo;

    /**
     * 平台单号(来源于第三方系统),如果是第三方新建的，需要传入
     **/
    @ApiModelProperty(name = "platformOrderNo", value = "平台单号(来源于第三方系统)")
    private String platformOrderNo;
    /**
     * 单据类型:purchase-采购订单,outsource-委外订单,production-生产订单
     * com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum
     **/
    @ApiModelProperty(name = "orderType", value = "单据类型:purchase-采购订单,outsource-委外订单,production-生产订单")
    private String orderType;
    /**
     * 业务类型:purchase-采购促销订单,outsource-委外订单,production-生产成品
     * com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderBusinessTypeEnum
     **/
    @ApiModelProperty(name = "businessType", value = "业务类型:purchase-采购促销订单,outsource-委外订单,production-生产订单")
    private String businessType;

    /**
     * 收货仓库编码
     **/
    @ApiModelProperty(name = "warehouseCode", value = "收货仓库编码")
    private String warehouseCode;

    /**
     * 供应商编码
     **/
    @ApiModelProperty(name = "supplierCode", value = "供应商编码")
    private String supplierCode;

    /**
     * 备注
     **/
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /**
     * 操作类型  draft-保存草稿   submit-提交
     **/
    @ApiModelProperty(name = "operateFlag", value = "操作类型  draft-保存草稿   submit-提交")
    private String operateFlag;

    /**
     * 预计到货时间
     **/
    @ApiModelProperty(name = "estimatedTime", value = "预计到货时间")
    private Date estimatedTime;

    /**
     * 商品信息
     **/
    @ApiModelProperty(name = "itemDetailList", value = "备注")
    private List<CsInPlannedOrderGenerateDetailReqDto> itemDetailList;

    //==========================外部无需关注字段
    /**
     * 收货仓库ID
     **/
    @ApiModelProperty(name = "warehouseId", value = "收货仓库ID",hidden = true)
    private Long warehouseId;

    /**
     * 收货仓库名称
     **/
    @ApiModelProperty(name = "warehouseName", value = "收货仓库名称",hidden = true)
    private String warehouseName;

    /**
     * 供应商ID
     **/
    @ApiModelProperty(name = "supplierId", value = "供应商ID",hidden = true)
    private Long supplierId;

    /**
     * 供应商名称
     **/
    @ApiModelProperty(name = "supplierName", value = "供应商名称",hidden = true)
    private String supplierName;

    @ApiModelProperty(name="createTime",value = "创建时间")
    private Date createTime;

    @ApiModelProperty(name="createPerson",value = "创建人")
    private String createPerson;

    @ApiModelProperty(name="sourceSystem",value = "来源系统")
    private String sourceSystem;

    /**
     * 组织ID
     **/
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
     * 组织名称
     **/
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getSourceSystem() {
        return sourceSystem;
    }

    public void setSourceSystem(String sourceSystem) {
        this.sourceSystem = sourceSystem;
    }

    public String getPlatformOrderNo() {
        return platformOrderNo;
    }

    public void setPlatformOrderNo(String platformOrderNo) {
        this.platformOrderNo = platformOrderNo;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public List<CsInPlannedOrderGenerateDetailReqDto> getItemDetailList() {
        return itemDetailList;
    }

    public void setItemDetailList(List<CsInPlannedOrderGenerateDetailReqDto> itemDetailList) {
        this.itemDetailList = itemDetailList;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getOperateFlag() {
        return operateFlag;
    }

    public void setOperateFlag(String operateFlag) {
        this.operateFlag = operateFlag;
    }

    public Date getEstimatedTime() {
        return estimatedTime;
    }

    public void setEstimatedTime(Date estimatedTime) {
        this.estimatedTime = estimatedTime;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreatePerson() {
        return createPerson;
    }

    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }
}