/**
 * @(#)CsInPlannedOrderUpdateReqDto.java 1.0 2022/04/13 15:39
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
* @Description CsInPlannedOrderUpdateReqDto
*
* @author jingran
* @Date: 2022/04/13 15:39
* @since 1.0.0
*/
@ApiModel(value = "csInPlannedOrderUpdateReqDto", description = "修改Dto")
public class CsInPlannedOrderUpdateReqDto implements Serializable {

    /** 平台单号(来源于第三方系统) */
    @ApiModelProperty(name="platformOrderNo",value = "平台单号(来源于第三方系统)")
    private String platformOrderNo;
    /** 单据号,系统生成的计划类单据号 */
    @ApiModelProperty(name="orderNo",value = "单据号,系统生成的计划类单据号")
    private String orderNo;
    /** 单据类型:purchase-采购订单,outsource-委外订单,production-生产订单 */
    @ApiModelProperty(name="orderType",value = "单据类型:purchase-采购订单,outsource-委外订单,production-生产订单")
    private String orderType;
    /** 业务类型:purchase-采购促销订单,outsource-委外订单,production-生产订单 */
    @ApiModelProperty(name="businessType",value = "业务类型:purchase-采购促销订单,outsource-委外订单,production-生产订单")
    private String businessType;
    /** 单据状态:wait_submit-待提交,wait_audit-待审核,audit_failed-审核不通过,wait_in-待入库,cancel-已取消,portion_in-部分入库,completed-已完成,hang_up-挂起 */
    @ApiModelProperty(name="orderStatus",value = "单据状态:wait_submit-待提交,wait_audit-待审核,audit_failed-审核不通过,wait_in-待入库,cancel-已取消,portion_in-部分入库,completed-已完成,hang_up-挂起")
    private String orderStatus;
    /** 收货仓库ID */
    @ApiModelProperty(name="receiveWarehouseId",value = "收货仓库ID")
    private Long receiveWarehouseId;
    /** 收货仓库编码 */
    @ApiModelProperty(name="receiveWarehouseCode",value = "收货仓库编码")
    private String receiveWarehouseCode;
    /** 收货仓库名称 */
    @ApiModelProperty(name="receiveWarehouseName",value = "收货仓库名称")
    private String receiveWarehouseName;
    /** 供应商ID */
    @ApiModelProperty(name="supplierId",value = "供应商ID")
    private Long supplierId;
    /** 供应商编码 */
    @ApiModelProperty(name="supplierCode",value = "供应商编码")
    private String supplierCode;
    /** 供应商名称 */
    @ApiModelProperty(name="supplierName",value = "供应商名称")
    private String supplierName;
    /** 总数量 */
    @ApiModelProperty(name="totalQuantity",value = "总数量")
    private BigDecimal totalQuantity;
    /** 已入总数量 */
    @ApiModelProperty(name="doneInQuantity",value = "已入总数量")
    private BigDecimal doneInQuantity;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;
    /** 组织ID */
    @ApiModelProperty(name="organizationId",value = "组织ID")
    private Long organizationId;
    /** 组织名称 */
    @ApiModelProperty(name="organizationName",value = "组织名称")
    private String organizationName;

    public String getPlatformOrderNo() {
        return platformOrderNo;
    }

    public void setPlatformOrderNo(String platformOrderNo) {
        this.platformOrderNo = platformOrderNo;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Long getReceiveWarehouseId() {
        return receiveWarehouseId;
    }

    public void setReceiveWarehouseId(Long receiveWarehouseId) {
        this.receiveWarehouseId = receiveWarehouseId;
    }

    public String getReceiveWarehouseCode() {
        return receiveWarehouseCode;
    }

    public void setReceiveWarehouseCode(String receiveWarehouseCode) {
        this.receiveWarehouseCode = receiveWarehouseCode;
    }

    public String getReceiveWarehouseName() {
        return receiveWarehouseName;
    }

    public void setReceiveWarehouseName(String receiveWarehouseName) {
        this.receiveWarehouseName = receiveWarehouseName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public BigDecimal getDoneInQuantity() {
        return doneInQuantity;
    }

    public void setDoneInQuantity(BigDecimal doneInQuantity) {
        this.doneInQuantity = doneInQuantity;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

}