package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in;

import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsWmsShippingInfoReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author jingran
 * @version 1.0
 * @Date 2022/4/19 3:55 下午
 */
@ApiModel(value = "CsWmsInSendBackReqDto", description = "wm入库回传DTO")
@Getter
@Setter
public class CsWmsInSendBackReqDto implements Serializable {

    /**
     * wms订单号
     **/
    @ApiModelProperty(name = "wmsOrderNo", value = "wms订单号")
    private String wmsOrderNo;

    /**
     * 平台单号(来源于第三方系统)
     **/
    @ApiModelProperty(name = "platformOrderNo", value = "平台单号(来源于第三方系统)")
    private String platformOrderNo;

    /**
     * 入库通知单号
     **/
    @ApiModelProperty(name = "inNoticeOrderNo", value = "入库通知单号")
    private String inNoticeOrderNo;

    /**
     * 入库时间
     **/
    @ApiModelProperty(name = "inTime", value = "入库时间")
    private Date inTime;

    /**
     * 商品明细信息
     **/
    @ApiModelProperty(name = "detailReqDtoList", value = "商品明细信息")
    private List<CsWmsInSendBackDetailReqDto> detailReqDtoList;
    /**
     * 物流信息
     **/
    @ApiModelProperty(name = "shippingInfoReqDtoList", value = "物流信息")
    private List<CsWmsShippingInfoReqDto> shippingInfoReqDtoList;

    /**
     * 是否需要计算超收、超发，默认需要true计算，false不需要计算
     **/
    @ApiModelProperty(name = "calculateOverchargeFlag", value = "是否需要计算超收、超发，默认需要true计算，false不需要计算")
    private Boolean calculateOverchargeFlag = true;

    @ApiModelProperty(name = "enableAdjustInTransit", value = "是否需要调整在途(满足前提情况下)")
    private Boolean enableAdjustInTransit  = false;

    private String bizType;

}
